% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{estimate_autotheta_1subpop_genotypes}
\alias{estimate_autotheta_1subpop_genotypes}
\title{Estimate autosomal theta from genotypes}
\usage{
estimate_autotheta_1subpop_genotypes(genotypes, return_estimation_info = FALSE)
}
\arguments{
\item{genotypes}{Matrix of genotypes: two columns (allele1 and allele2) and a row per individual}

\item{return_estimation_info}{Whether to return the quantities used to estimate \code{theta}}
}
\value{
List:
\itemize{
\item \code{theta}
\itemize{
\item \code{estimate}: Vector of length 1 containing estimate of theta or NA if it could not be estimated
\item \code{error}: true if an error happened, false otherwise
\item \code{details}: contains description if an error happened
\item \code{estimation_info}: If \code{return_estimation_info = true}: a list with information used to estimate \code{theta}. Else \code{NULL}.
}
}
}
\description{
Estimate autosomal theta for one subpopulation given a sample of genotypes.
}
\details{
Assumes that \code{\link[=pedigrees_all_populate_autosomal]{pedigrees_all_populate_autosomal()}} was used first to populate autosomal genotypes.
}
