% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qwen_processor.R
\name{QwenProcessor}
\alias{QwenProcessor}
\title{Qwen API Processor}
\description{
Qwen API Processor

Qwen API Processor
}
\details{
Concrete implementation of BaseAPIProcessor for Qwen models.
Handles Qwen-specific API calls, authentication, and response parsing.

Qwen has two API endpoints:
\itemize{
\item International: https://dashscope-intl.aliyuncs.com/api/v1/services/aigc/text-generation/generation (preferred)
\item Domestic (China): https://dashscope.aliyuncs.com/api/v1/services/aigc/text-generation/generation (fallback)
The processor automatically tries international first, then falls back to domestic if needed.
}
}
\section{Super class}{
\code{mLLMCelltype::BaseAPIProcessor} -> \code{QwenProcessor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-QwenProcessor-new}{\code{QwenProcessor$new()}}
\item \href{#method-QwenProcessor-get_default_api_url}{\code{QwenProcessor$get_default_api_url()}}
\item \href{#method-QwenProcessor-get_working_api_url}{\code{QwenProcessor$get_working_api_url()}}
\item \href{#method-QwenProcessor-make_api_call}{\code{QwenProcessor$make_api_call()}}
\item \href{#method-QwenProcessor-extract_response_content}{\code{QwenProcessor$extract_response_content()}}
\item \href{#method-QwenProcessor-clone}{\code{QwenProcessor$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mLLMCelltype" data-topic="BaseAPIProcessor" data-id="get_api_url"><a href='../../mLLMCelltype/html/BaseAPIProcessor.html#method-BaseAPIProcessor-get_api_url'><code>mLLMCelltype::BaseAPIProcessor$get_api_url()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mLLMCelltype" data-topic="BaseAPIProcessor" data-id="process_request"><a href='../../mLLMCelltype/html/BaseAPIProcessor.html#method-BaseAPIProcessor-process_request'><code>mLLMCelltype::BaseAPIProcessor$process_request()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QwenProcessor-new"></a>}}
\if{latex}{\out{\hypertarget{method-QwenProcessor-new}{}}}
\subsection{Method \code{new()}}{
Test if an endpoint is accessible


Initialize Qwen processor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QwenProcessor$new(base_url = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_url}}{Optional custom base URL for Qwen API}

\item{\code{url}}{The endpoint URL to test}

\item{\code{api_key}}{API key for authentication}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if accessible, FALSE otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QwenProcessor-get_default_api_url"></a>}}
\if{latex}{\out{\hypertarget{method-QwenProcessor-get_default_api_url}{}}}
\subsection{Method \code{get_default_api_url()}}{
Get default Qwen API URL with intelligent endpoint selection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QwenProcessor$get_default_api_url()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Default Qwen API endpoint URL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QwenProcessor-get_working_api_url"></a>}}
\if{latex}{\out{\hypertarget{method-QwenProcessor-get_working_api_url}{}}}
\subsection{Method \code{get_working_api_url()}}{
Get working Qwen API URL with automatic endpoint detection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QwenProcessor$get_working_api_url(api_key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_key}}{API key for testing endpoints}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Working Qwen API endpoint URL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QwenProcessor-make_api_call"></a>}}
\if{latex}{\out{\hypertarget{method-QwenProcessor-make_api_call}{}}}
\subsection{Method \code{make_api_call()}}{
Make API call to Qwen
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QwenProcessor$make_api_call(chunk_content, model, api_key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{chunk_content}}{Content for this chunk}

\item{\code{model}}{Model identifier}

\item{\code{api_key}}{API key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
httr response object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QwenProcessor-extract_response_content"></a>}}
\if{latex}{\out{\hypertarget{method-QwenProcessor-extract_response_content}{}}}
\subsection{Method \code{extract_response_content()}}{
Extract response content from Qwen API response
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QwenProcessor$extract_response_content(response, model)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{response}}{httr response object}

\item{\code{model}}{Model identifier}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Extracted text content
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QwenProcessor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-QwenProcessor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QwenProcessor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
