% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_correct_sentence.R
\name{prop_correct_sentence}
\alias{prop_correct_sentence}
\title{Proportion Correct for Sentences}
\usage{
prop_correct_sentence(
  data,
  responses,
  key,
  key.trial,
  id,
  id.trial,
  cutoff = 0,
  flag = FALSE,
  group.by = NULL,
  token.split = " "
)
}
\arguments{
\item{data}{a dataframe of the variables you would like to return.
Other variables will be included in the scored output and
in the participant output if they are a one to one match with
the participant id.}

\item{responses}{a column name in the dataframe that contains
the participant answers for each item in quotes (i.e., "column")}

\item{key}{a vector containing the scoring key or data column name.
This column does not have to be included in the original dataframe.}

\item{key.trial}{a vector containing the trial numbers for each answer.
Note: If you input long data (i.e., repeating trial-answer responses),
we will take the unique combination of the responses. If a trial number
is repeated, you will receive an error. Key and key.trial can also be
a separate dataframe, depending on how your output data is formatted.}

\item{id}{a column name containing participant ID numbers from
the original dataframe}

\item{id.trial}{a column name containing the trial numbers
for the participant data from the original dataframe}

\item{cutoff}{a numeric value that determines the criteria for
scoring (i.e., 0 = strictest, 5 = is most lenient). The scoring
criteria uses a Levenshtein distance measure to match participant
responses to the answer key.}

\item{flag}{a logical argument if you want to flag participant scores
that are outliers using z-scores away from the mean score for group}

\item{group.by}{an optional argument that can be used to group the
output by condition columns. These columns should be in the original
dataframe and concatenated c() if there are multiple columns}

\item{token.split}{an optional argument that can be used to delineate
how to separate tokens. The default is a space after punctuation and
additional spacing is removed.}
}
\value{
\item{DF_Scored}{The dataframe of the original response, answer,
scoring, and any other or grouping variables. This dataframe can
be used to determine if the cutoff score and scoring matched your
answer key as intended. Distance measures are not perfect! Issues
and suggestions for improvement are welcome.}
\item{DF_Participant}{A dataframe of the proportion correct by
participant, which also includes optional z-scoring, grouping, and
other variables.}
\item{DF_Group}{A dataframe of the summary scores by any optional
grouping variables, along with overall total proportion correct
scoring.}
}
\description{
This function computes the proportion of correct sentence responses
per participant. Proportions can either be separated by
condition or collapsed across conditions. You will need to ensure
each trial is marked with a unique id to correspond to the answer
key.
}
\details{
Note: other columns included in the dataframe will be found
in the final scored dataset. If these other columns are
between subjects data, they will also be included in the
participant dataset (i.e., there's a one to one match of
participant ID and column information).
}
\examples{

#This data contains sentence recall test with responses and answers together.
#You can use a separate answer key, but this example will show you an
#embedded answer key. This example also shows how you can use different
#stimuli across participants (i.e., each person sees a randomly selected
#set of trials from a larger set).

data(sentence_data)

scored_output <- prop_correct_sentence(data = sentence_data,
 responses = "Response",
 key = "Sentence",
 key.trial = "Trial.ID",
 id = "Sub.ID",
 id.trial = "Trial.ID",
 cutoff = 1,
 flag = TRUE,
 group.by = "Condition",
 token.split = " ")

head(scored_output$DF_Scored)

head(scored_output$DF_Participant)

head(scored_output$DF_Group)

}
\keyword{correct}
\keyword{proportion}
\keyword{recall}
\keyword{scoring}
\keyword{sentences}
