# lightsf - Collection of georeferenced and spatial datasets from different domains
# Version 0.1.0
# Copyright (C) 2025 Ingrid Romero Pinilla
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# nc_points


library(testthat)

# Test 1: Confirm the object is a data.frame
test_that("nc_points is a data.frame", {
  expect_s3_class(nc_points, "data.frame")
})

# Test 2: Confirm it has exactly 2 columns
test_that("nc_points has 2 columns", {
  expect_equal(length(nc_points), 2)
})

# Test 3: Confirm it has exactly 2304 rows
test_that("nc_points has 2304 rows", {
  expect_equal(nrow(nc_points), 2304)
})

# Test 4: Confirm column names are correct
test_that("nc_points has correct column names", {
  expect_named(nc_points, c("X", "Y"))
})

# Test 5: Confirm column types are as expected
test_that("nc_points columns have correct types", {
  expect_type(nc_points$X, "double")
  expect_type(nc_points$Y, "double")
})

