% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5extreme.R
\name{rfa}
\alias{rfa}
\title{Regional Frequency Analysis}
\usage{
rfa(lflist, n = 7, event = 100, dist = c("wei", "gev", "ln3", "gum", "pe3"))
}
\arguments{
\item{lflist}{A list of \code{'lfobj'}s.}

\item{n}{\acronym{MAM}-n is used (e.g. n=7 means \acronym{MAM}7).}

\item{event}{A value for T, e.g. event = 100 means the 100 years extreme low flow event.}

\item{dist}{A vector of distribution to fit, the names are according to
Hosking's in his \pkg{lmom} package. Can be an of  \code{"wei"}, \code{"gev"},
\code{"ln3"}, \code{"gum"}, \code{"pe3"}.}
}
\value{
An object of class \code{"rfd"},
containing the specification of the regional frequency distribution:
It is a list with the following elements:
\item{dist}{The character string \code{dist}.}
\item{para}{Vector containing the parameters of the fitted regional distribution.}
\item{qfunc}{The quantile function of distribution \code{dist}.
It is a function that takes a single argument, a vector of probabilities,
and returns a vector of quantiles.}
\item{rmom}{The regional average \eqn{L}-moments.}
\item{index}{Index flood values at each site.  This is a named vector
whose values are the index flood values at each site, from \code{regdata[[3]]},
and whose names are the site names, from \code{regdata[[1]]}.}
}
\description{
This function uses J.R.M. Hosking's package produce an object of class
\code{'rfd'}, containing the specification of the regional frequency distribution.
}
\examples{
data(ngaruroro)
# Toy example to get some more "rivers"
seventies <- subset(ngaruroro, hyear \%in\% 1970:1979)
eighties <- subset(ngaruroro, hyear \%in\% 1980:1989)
nineties <- subset(ngaruroro, hyear \%in\% 1990:1999)

toyrfa <- rfa(list(seventies,eighties,nineties), n=3,dist = "gev")

require(lmomRFA)
regquant(c(1/1000,1/100),toyrfa)
sitequant(1/100,toyrfa)
}
\references{
Gustard, A. & Demuth, S. (2009) (Eds) Manual on Low-flow Estimation
and Prediction. Operational Hydrology Report No. 50, \acronym{WNO}-No. 1029, 136p.
\url{https://library.wmo.int/idurl/4/32176}
}
\seealso{
\code{\link[lmomRFA]{regfit}} and \code{\link[lmom]{lmom-package}} which this function wraps.
}
\keyword{Analysis}
\keyword{Frequency}
\keyword{Regional}
