% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapes-caps.R
\name{cap_options}
\alias{cap_options}
\alias{cap_triangle}
\alias{cap_round}
\alias{cap_arch}
\alias{cap_ogee}
\alias{cap_none}
\title{Cap options}
\usage{
cap_triangle()

cap_round(n = 100)

cap_arch(n = 100)

cap_ogee(n = 100)

cap_none()
}
\arguments{
\item{n}{An \verb{<integer[n]>} number of points to use for the cap.}
}
\value{
A \verb{<matrix[n, 2]>} with coordinates for points on the brackets.
}
\description{
These functions construct various sorts of caps. They construct a matrix
that can be supplied as the \code{shape} argument in \code{\link[=gizmo_barcap]{gizmo_barcap()}}.
}
\details{
When designing custom cap shapes, the expectation is that the first point
starts at the \verb{(0, 0)} coordinate and the last point ends at the \verb{(0, 1)}
coordinate. The first column follows the orthogonal direction of the bar
whereas the second column follows the direction of the bar.
}
\section{Functions}{
\itemize{
\item \code{cap_triangle()}: An equilateral triangle with \code{n = 3} points.

\item \code{cap_round()}: A semicircle.

\item \code{cap_arch()}: Two circular arcs forming an equilateral Gothic arch.

\item \code{cap_ogee()}: Four circular arcs forming an 'ogee' arch.

\item \code{cap_none()}: No cap.

}}
\examples{
plot(cap_arch(), type = 'l')
}
