% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{anthyllis}
\alias{anthyllis}
\title{Matrix Set of \emph{Anthyllis vulneraria} Populations in Belgium}
\format{
A \code{lefkoMat} object holding 27 matrices. The structure of the
object is as below:

\describe{
  \item{A}{The 27 A matrices.}
  \item{U}{The 27 survival-transition matrices used to develop the A
  matrices.}
  \item{F}{The 27 fecundity matrices used to develop the A matrices.}
  \item{hstages}{Not used, so set to \code{NA}.}
  \item{agestages}{Not used, so set to \code{NA}.}
  \item{ahstages}{The edited stageframe describing the life history of the
  study organism as interpreted in the original demographic study.}
  \item{labels}{The order of the matrices, where each population is treated
  as a separate patch and each matrix corresponds to a different combination
  of population and year in time \emph{t}.}
  \item{matrixqc}{A vector of integers used in the quality control section of
  \code{lefkoMat} summary statements.}
  \item{dataqc}{Currently a vector with two \code{NA} values.}
}
}
\source{
Davison, R. et al. 2010. Demographic effects of extreme weather
events on a short-lived calcareous grassland species: stochastic life table
response experiments. \emph{Journal of Ecology} 98(2):255-267.
}
\usage{
data(anthyllis)
}
\description{
A \code{lefkoMat} object containing projection matrices developed from
demographic data gathered on nine \emph{Anthyllis vulneraria} populations
from 2003 to 2006 in southwestern Belgium.
}
\examples{
data(anthyllis)

lambda3(anthyllis)
}
\keyword{datasets}
