% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{GS}
\alias{GS}
\title{Gini-Simpson index of foliage structural diversity}
\usage{
GS(lad_profile, evenness = FALSE, LAD.threshold = -1)
}
\arguments{
\item{lad_profile}{a data.frame including values of relative LAD at height intervals, output of the lad.profile function (use relative = TRUE)}

\item{evenness}{boolean, defines whether GS should be based on Simpson's diversity or evenness (Hill 1973).
The default FALSE calculates Simpson's diversity (\eqn{\gamma});
the alternative TRUE was recommended by Valbuena et al. (2012), and it divides by the number of voxels with LAD values above the threshold, following Smith and Wilson (1996).}

\item{LAD.threshold}{numerical (0,1), defines the minimum value of LAD for considering the relative leaf abundance of a voxel in GS calculation. Defaults to the inverse of the total number of voxels.}
}
\value{
A \code{\link[base:numeric]{numeric}} containing the Fini-Simpson index calculated from the Leaf Area Density profile
}
\description{
Calculates the Gini-Simpson (GS) index metric (i.e. complement of Simpson diversity (\eqn{1 - \gamma})
from abundances considered as per-voxel relative LAD values.
}
\examples{
# Get the example laz file
normlas.file = system.file("extdata", "lidar_example.laz", package="leafR")

# Calculate LAD from voxelization
VOXELS_LAD = lad.voxels(normlas.file,
                        grain.size = 2)

# Calculate the LAD profile
lad_profile = lad.profile(VOXELS_LAD, relative = TRUE)

GS(lad_profile, evenness = FALSE)
GS(lad_profile, evenness = TRUE)

}
\references{
Hill M. O. (1973) Diversity and evenness: a unifying notation and its consequences. Ecology. 54: 427–432. \doi{10.2307/1934352}

Smith B., and Wilson J.B. (1996). A consumer's guide to evenness indices. Oikos 76: 70–82. \doi{10.2307/3545749}

Valbuena R., Packalen P., Martín-Fernández S., Maltamo M. (2012) Diversity and equitability ordering profiles applied to the study of forest structure. Forest Ecology and Management 276: 185–195. \doi{10.1016/j.foreco.2012.03.036}
}
