% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gblemp.R
\name{gblemp}
\alias{gblemp}
\alias{gbltrad}
\title{Empirical Gliding Box Lacunarity}
\usage{
gblemp(boxwidths, xiim, obswin = Frame(xiim))

gbltrad(boxwidths, xiim, obswin = Frame(xiim))
}
\arguments{
\item{boxwidths}{A list of suggested box widths in the same units as \code{xiim}.
Note the actual box widths used by \code{gblemp} will be the closest multiple of an odd number of pixel widths.}

\item{xiim}{An image of pixels valued either \code{0}, \code{1} or \code{NA}. \code{NA} valued pixels are assumed to be outside the observation window.}

\item{obswin}{Optional observation window. The observation window used for the estimator will be the intersection of \code{obswin} and the pixels that are not \code{NA} in \code{xiim}.}
}
\value{
An \code{fv} object containing empirical GBL, variance of the area in the box and mean of the area in the box.
The box widths (labelled \code{s}) are always odd multiples of the pixel width.
}
\description{
Calculates empirical gliding box lacunarity of a binary map, which was proposed by Allain and Cloitre (1991).
}
\details{
Calculates empirical gliding box lacunarity (Allain and Cloitre, 1991) for a given range of square box sizes,
\deqn{1 + Var(area(B . xi)) / E[area(B . xi)]^2, }
where \eqn{B} is a box that has a random location in the observation window and \eqn{area(B . xi)} is the (random) area of the foreground in \eqn{B}.
This is an estimate of the gliding box lacunarity of a RACS (Hingee et al., 2017).

The algorithm uses the pixel locations in \code{xiim} as an array of box centre locations to compute
the mean and variance of the area in a random box of a given size.
Locations where the box is not completely within the observation window are ignored.
}
\section{Functions}{
\itemize{
\item \code{gbltrad()}: An alias of \code{gblemp} used in past versions of this package. This alias may be removed in future versions.

}}
\section{WARNING}{

The box side lengths are rounded such that they are an odd number of pixels across.
\code{gblemp} uses the \code{\link[RcppRoll]{roll_sum}} function in \pkg{RcppRoll} to operate, so \pkg{RcppRoll} must be installed to run \code{gblemp}.
}

\examples{
xiim <- as.im(heather$coarse, na.replace = 0)
boxwidths <- seq(0.2, 14, by = 0.2) #in units of xiim
gblest <- gblemp(boxwidths, xiim)

}
\references{
Allain, C. and Cloitre, M. (1991) Characterizing the lacunarity of random and deterministic fractal sets. \emph{Physical Review A}, 44, 3552-3558.

Hingee K, Baddeley A, Caccetta P, Nair G (2019). Computation of lacunarity from covariance of spatial binary maps. \emph{Journal of Agricultural, Biological and Environmental Statistics}, 24, 264-288. DOI: 10.1007/s13253-019-00351-9.
}
\keyword{nonparametric}
\keyword{spatial}
