% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F4_harmonize_lab_unit_V5.R
\name{harmonize_lab_unit}
\alias{harmonize_lab_unit}
\title{Harmonizing Laboratory Units of Measurement through Unit Conversion}
\usage{
harmonize_lab_unit(
  lab_data,
  loinc_code,
  result_value,
  result_unit,
  preferred_unit_system = "SI",
  report = TRUE
)
}
\arguments{
\item{lab_data}{A data frame containing laboratory data.}

\item{loinc_code}{The column in `lab_data` indicating the LOINC code of the laboratory test.}

\item{result_value}{The column in `lab_data` with quantitative result values for conversion.}

\item{result_unit}{The column in `lab_data` with result units in a UCUM-valid format.}

\item{preferred_unit_system}{A string representing the preference of the user for the unit system used for standardization. Defaults to "SI", the other option is "Conventional".}

\item{report}{A report is written in the console. Defaults to "TRUE".}
}
\value{
A modified `lab_data` data frame with additional columns (original row order preserved):
  * `harmonized_unit`: Harmonized units according to the preferred unit system.
  * `OMOP_concept_id`: The concept id of the harmonized unit according to the OMOP Common Data Model.
  * `new_value`: The result value after the conversion.
  * `new_loinc_code`: If the unit conversion led to a new loinc code (e.g. in mass-molar conversion).
  * `property_group_id`: the code of the LOINC group (parent group ID / Group ID).
  * `cleaning_comments`: Comments about the harmonization and conversion process for each lab result.
}
\description{
This function is designed to harmonize the units found in a laboratory data set
to either SI or Conventional units, converting the numeric result values in
the process and (optionally) updating LOINC codes when mass–molar conversion
are required.
}
\details{
The function undergoes the following methodology:
  1. Extracting unit parameters (dimension & magnitude)
  2. Setting reference unit (LOINC-UCUM mapping)
  3. Check compatibility between reported unit and reference unit
  4. Executing regular conversion
  5. Executing mass<>molar conversion
  6. Checking LOINC codes

Internal Datasets:
The function uses an internal dataset; `parsed_units_df` which contains 1450 parsed ucum units
}
\note{
This function is part of a larger data cleaning pipeline and should be evaluated in that context.
The package framework includes functions for cleaning result values and validating quantitative results for each test identifier.

Performance of the function can be affected by the size of `lab_data`. Considerations for data size
or pre-processing may be needed.
}
\seealso{
Function 1 for result value cleaning,
Function 2 for result validation,
Function 3 for unit format standardized to UCUM,
}
\author{
Ahmed Zayed <ahmed.zayed@kuleuven.be>, Ilias Sarikakis <sarikakisilias@gmail.com>
}
