% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{custom_metric}
\alias{custom_metric}
\title{Custom metric function}
\usage{
custom_metric(name, metric_fn)
}
\arguments{
\item{name}{name used to show training progress output}

\item{metric_fn}{An R function with signature \code{function(y_true, y_pred){}} that accepts tensors.}
}
\description{
Custom metric function
}
\details{
You can provide an arbitrary R function as a custom metric. Note that
the \code{y_true} and \code{y_pred} parameters are tensors, so computations on
them should use backend tensor functions.

Use the \code{custom_metric()} function to define a custom metric.
Note that a name ('mean_pred') is provided for the custom metric
function: this name is used within training progress output.

If you want to save and load a model with custom metrics, you should
also specify the metric in the call the \code{\link[=load_model_hdf5]{load_model_hdf5()}}. For example:
\code{load_model_hdf5("my_model.h5", c('mean_pred' = metric_mean_pred))}.

Alternatively, you can wrap all of your code in a call to
\code{\link[=with_custom_object_scope]{with_custom_object_scope()}} which will allow you to refer to the
metric by name just like you do with built in keras metrics.

Documentation on the available backend tensor functions can be
found at \url{https://tensorflow.rstudio.com/reference/keras/#backend}.

Alternative ways of supplying custom metrics:
\itemize{
\item \verb{custom_metric():} Arbitrary R function.
\item \code{\link[=metric_mean_wrapper]{metric_mean_wrapper()}}: Wrap an arbitrary R function in a \code{Metric} instance.
\item subclass \code{keras$metrics$Metric}: see \code{?Metric} for example.
}
}
\seealso{
Other metrics: 
\code{\link{metric_accuracy}()},
\code{\link{metric_auc}()},
\code{\link{metric_binary_accuracy}()},
\code{\link{metric_binary_crossentropy}()},
\code{\link{metric_categorical_accuracy}()},
\code{\link{metric_categorical_crossentropy}()},
\code{\link{metric_categorical_hinge}()},
\code{\link{metric_cosine_similarity}()},
\code{\link{metric_false_negatives}()},
\code{\link{metric_false_positives}()},
\code{\link{metric_hinge}()},
\code{\link{metric_kullback_leibler_divergence}()},
\code{\link{metric_logcosh_error}()},
\code{\link{metric_mean}()},
\code{\link{metric_mean_absolute_error}()},
\code{\link{metric_mean_absolute_percentage_error}()},
\code{\link{metric_mean_iou}()},
\code{\link{metric_mean_relative_error}()},
\code{\link{metric_mean_squared_error}()},
\code{\link{metric_mean_squared_logarithmic_error}()},
\code{\link{metric_mean_tensor}()},
\code{\link{metric_mean_wrapper}()},
\code{\link{metric_poisson}()},
\code{\link{metric_precision}()},
\code{\link{metric_precision_at_recall}()},
\code{\link{metric_recall}()},
\code{\link{metric_recall_at_precision}()},
\code{\link{metric_root_mean_squared_error}()},
\code{\link{metric_sensitivity_at_specificity}()},
\code{\link{metric_sparse_categorical_accuracy}()},
\code{\link{metric_sparse_categorical_crossentropy}()},
\code{\link{metric_sparse_top_k_categorical_accuracy}()},
\code{\link{metric_specificity_at_sensitivity}()},
\code{\link{metric_squared_hinge}()},
\code{\link{metric_sum}()},
\code{\link{metric_top_k_categorical_accuracy}()},
\code{\link{metric_true_negatives}()},
\code{\link{metric_true_positives}()}
}
\concept{metrics}
