% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contour.kdevinecop.R
\name{contour.kdevinecop}
\alias{contour.kdevinecop}
\title{Contour plots of pair copula kernel estimates}
\usage{
\method{contour}{kdevinecop}(x, tree = "ALL", xylim = NULL, cex.nums = 1, ...)
}
\arguments{
\item{x}{a \code{\link{kdevinecop}} object.}

\item{tree}{\code{"ALL"} or integer vector; specifies which trees are
plotted.}

\item{xylim}{numeric vector of length 2; sets \code{xlim} and \code{ylim}
for the contours.}

\item{cex.nums}{numeric; expansion factor for font of the numbers.}

\item{...}{arguments passed to \code{\link[kdecopula]{contour.kdecopula}}.}
}
\description{
Contour plots of pair copula kernel estimates
}
\examples{
data(wdbc, package = "kdecopula")                     # load data
u <- VineCopula::pobs(wdbc[, 5:7], ties = "average")  # rank-transform
\dontshow{wdbc <- wdbc[1:30, ]}
# estimate density
fit <- kdevinecop(u)

# contour matrix
contour(fit)

}
