% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jjcsformats.R
\name{jjcsformat_range_fct}
\alias{jjcsformat_range_fct}
\title{Function factory for range with censoring information formatting}
\usage{
jjcsformat_range_fct(str)
}
\arguments{
\item{str}{\code{string}\cr the format specifying the number of digits to be used,
for the range values, e.g. \code{"xx.xx"}.}
}
\value{
A function that formats a numeric vector with 4 elements:
\itemize{
\item minimum
\item maximum
\item censored minimum? (1 if censored, 0 if event)
\item censored maximum? (1 if censored, 0 if event)
The range along with the censoring information is returned as a string
with the specified numeric format as \verb{(min, max)}, and the \code{+} is appended
to \code{min} or \code{max} if these have been censored.
}
}
\description{
A function factory to generate formatting functions for range formatting
that includes information about the censoring of survival times.
}
\examples{
my_range_format <- jjcsformat_range_fct("xx.xx")
my_range_format(c(0.35235, 99.2342, 1, 0))
my_range_format(c(0.35235, 99.2342, 0, 1))
my_range_format(c(0.35235, 99.2342, 0, 0))
my_range_format(c(0.35235, 99.2342, 1, 1))
}
\seealso{
Other JJCS formats: 
\code{\link{count_fraction}},
\code{\link{format_xx_fct}()},
\code{\link{jjcsformat_pval_fct}()}
}
\concept{JJCS formats}
