% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draft.R
\name{draft}
\alias{draft}
\title{Creat A Draft of JDS Article}
\usage{
draft(file, cls = c("jdsart", "jds"))
}
\arguments{
\item{file}{A character string for the file name of the draft.  Different
with \code{rmarkdown::draft()}, the suffix \code{".Rmd"} will not be
added if it is not specified.}

\item{cls}{The LaTeX class name. The available choices are \code{jdsart} for
the latest class developed by vtex, or \code{jds} for the deprecated
class.}
}
\value{
The file name of the new document (invisibly).
}
\description{
Create a JDS article draft using the specified LaTeX class file.  This
function is a simplified version of `rmarkdown::draft()` for creating a JDS
article draft only.
}
\examples{
if (interactive() && requireNamespace("rmarkdown", quietly = TRUE)) {
    ## draft from a sample R markdown file
    jds.rmd::draft("jds-sample.Rmd")
    ## produce pdf with the tex source kept for submission
    rmarkdown::render("jds-sample.Rmd")
}
}
