% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.EnviChange}
\alias{plot.EnviChange}
\title{Display the figure and map of the \code{EnviChange} object.}
\usage{
\method{plot}{EnviChange}(x, ...)
}
\arguments{
\item{x}{(\code{EnviChange}) A \code{EnviChange} object to be messaged.
It could be the return of function \code{\link{detect_envi_change}}.}

\item{...}{Not used.}
}
\value{
The same object that was passed as input.
}
\description{
Show the response curve and the map of contribution change from
\code{\link{detect_envi_change}}.
}
\examples{
\donttest{
# Using a pseudo presence-only occurrence dataset of
# virtual species provided in this package
library(dplyr)
library(sf)
library(stars)
library(itsdm)
#'
# Prepare data
data("occ_virtual_species")
obs_df <- occ_virtual_species \%>\% filter(usage == "train")
eval_df <- occ_virtual_species \%>\% filter(usage == "eval")
x_col <- "x"
y_col <- "y"
obs_col <- "observation"
#'
# Format the observations
obs_train_eval <- format_observation(
  obs_df = obs_df, eval_df = eval_df,
  x_col = x_col, y_col = y_col, obs_col = obs_col,
  obs_type = "presence_only")
#'
env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12))
#'
# With imperfect_presence mode,
mod <- isotree_po(
  obs_mode = "imperfect_presence",
  obs = obs_train_eval$obs,
  obs_ind_eval = obs_train_eval$eval,
  variables = env_vars, ntrees = 10,
  sample_size = 0.8, ndim = 1L,
  seed = 123L, response = FALSE,
  spatial_response = FALSE,
  check_variable = FALSE)

# Use a fixed value
bio1_changes <- detect_envi_change(
  model = mod$model,
  var_occ = mod$vars_train,
  variables = mod$variables,
  shap_nsim = 1,
  target_var = "bio1",
  var_future = 5)

plot(bio1_changes)
}

}
\seealso{
\code{\link{detect_envi_change}}
}
