% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.SHAPSpatial}
\alias{plot.SHAPSpatial}
\title{Display Shapley values-based spatial variable dependence maps.}
\usage{
\method{plot}{SHAPSpatial}(x, target_var = NA, ...)
}
\arguments{
\item{x}{(\code{SHAPSpatial}) The spatial variable dependence object to plot.
It could be the return of function \code{\link{shap_spatial_response}}.}

\item{target_var}{(\code{vector} of \code{character}) The target variable to plot.
It could be \code{NA}. If it is \code{NA}, all variables will be plotted.}

\item{...}{Not used.}
}
\value{
\code{ggplot2} figure of dependent maps
}
\description{
Plot Shapley values-based spatial variable dependence maps
using ggplot2 by optionally setting target variable(s). This only works for
\code{SHAPSpatial} even though it is part of \code{SpatialResponse}.
}
\examples{
\donttest{
# Using a pseudo presence-only occurrence dataset of
# virtual species provided in this package
library(dplyr)
library(sf)
library(stars)
library(itsdm)

# Prepare data
data("occ_virtual_species")
obs_df <- occ_virtual_species \%>\% filter(usage == "train")
eval_df <- occ_virtual_species \%>\% filter(usage == "eval")
x_col <- "x"
y_col <- "y"
obs_col <- "observation"

# Format the observations
obs_train_eval <- format_observation(
  obs_df = obs_df, eval_df = eval_df,
  x_col = x_col, y_col = y_col, obs_col = obs_col,
  obs_type = "presence_only")

env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12))

# With imperfect_presence mode,
mod <- isotree_po(
  obs_mode = "imperfect_presence",
  obs = obs_train_eval$obs,
  obs_ind_eval = obs_train_eval$eval,
  variables = env_vars, ntrees = 20,
  sample_size = 0.8, ndim = 2L,
  seed = 123L, response = FALSE,
  spatial_response = FALSE,
  check_variable = FALSE)

shap_spatial <- shap_spatial_response(
 model = mod$model,
 target_vars = c("bio1", "bio12"),
 var_occ = mod$vars_train,
 variables = mod$variables,
 shap_nsim = 1)

plot(shap_spatial)
plot(shap_spatial, target_var = "bio1")
}

}
\seealso{
\code{\link{spatial_response}}
}
