% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options-package.R
\name{orbi_options}
\alias{orbi_options}
\alias{orbi_get_options}
\alias{orbi_get_option}
\alias{get_pkg_options}
\title{Package options}
\usage{
orbi_options(...)

orbi_get_options(pattern = NULL)

orbi_get_option(x)
}
\arguments{
\item{...}{set package options, syntax identical to \code{\link[=options]{options()}}}

\item{pattern}{to retrieve multiple options (as a list) with a shared pattern}

\item{x}{name of the specific option to retrieve}
}
\description{
These options are best set via \code{\link[=orbi_options]{orbi_options()}} and queried via \code{\link[=orbi_get_option]{orbi_get_option()}}. However, the base functions \code{\link[=options]{options()}} and \code{\link[=getOption]{getOption()}} work as well but require an \code{isoorbi.} prefix (the package name and a dot) for the option name. Setting an option to a value of \code{NULL} means that the default is used. \code{\link[=orbi_get_options]{orbi_get_options()}} is available as an additional convenience function to retrieve a subset of options with a regular expression pattern.
}
\section{Functions}{
\itemize{
\item \code{orbi_options()}: set/get option values

\item \code{orbi_get_options()}: get a subset of option values that fit a pattern

\item \code{orbi_get_option()}: retrieve the current value of one option (option must be defined for the package)

}}
\section{Options for the isoorbi package}{

\itemize{
\item \code{di_ref_name}: the text label for dual inlet reference blocks
\item \code{di_sample_name}: the text label for dual inlet sample blocks
\item \code{data_type_data}: the text used to flag raw data as actually being data
\item \code{data_type_startup}: the text used to flag raw data as being part of the startup
\item \code{data_type_changeover}: the text used to flag raw data as being part of a changeover
\item \code{data_type_unused}: the text used to flag raw data as being unused
\item \code{aggregators}: data aggregators for pulling data out of raw files. The list of available aggregators is accessible via \code{orbi_get_option("aggregators")}. Individiual aggregators are available via the shortcut helper function \code{orbi_get_aggregator("standard")}. Register new/overwrite existing aggregators via \code{orbi_register_aggregator()}.
\item \code{debug}: turn on debug mode
\item \code{auto_use_ansi}: whether to automatically enable correct rendering of stylized (ansi) output in HTML reports from notebooks that call \code{library(isoorbi)}. Can be turned off by calling \code{isoorbi::orbi_options(auto_use_ansi = FALSE)} \strong{before} call \code{library(isoorbi)}.
}
}

\examples{
# All default options
orbi_get_options()

# Options that contain 'data' in the name
orbi_get_options("data")

# Specific option
orbi_get_option("data_type_unused")

# Change an option
orbi_options(data_type_unused = "flagged")
orbi_get_option("data_type_unused")

# Change back to default
orbi_options(data_type_unused = NULL)
orbi_get_option("data_type_unused")

}
