% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_ipeaplot.R
\name{save_ipeaplot}
\alias{save_ipeaplot}
\title{Save ggplot in multiple formats}
\usage{
save_ipeaplot(
  gplot = ggplot2::last_plot(),
  file.name,
  format = NULL,
  width = 6.3,
  height = 3.94,
  units = c("in", "mm", "cm", "px"),
  dpi = 300,
  background = "white",
  quality = 95,
  path = ".",
  scale = 1,
  overwrite = TRUE,
  include_date = FALSE,
  date_format = "\%Y\%m\%d",
  use_cairo = TRUE,
  use_ragg = TRUE,
  quiet = TRUE,
  ...
)
}
\arguments{
\item{gplot}{ggplot object. Default: ggplot2::last_plot().}

\item{file.name}{Base name of the file (without extension). E.g., "results/figs/my_plot".}

\item{format}{Vector with one or more of: "eps", "jpg", "pdf", "png".
If NULL, uses getOption("ipea.plot.default_format", "eps").}

\item{width, height}{Plot dimensions (default 160 x 100).}

\item{units}{Units: "mm", "cm", "in", "px" (default "in").}

\item{dpi}{DPI for raster formats (default 300).}

\item{background}{Background color; use NA for transparent PNGs.
For JPEG (no transparency), NA becomes "white".}

\item{quality}{JPEG quality (0 to 100) (default 95).}

\item{path}{Output directory (default ".").}

\item{scale}{Scale factor passed to ggsave (default 1).}

\item{overwrite}{If FALSE, does not overwrite existing files: creates suffixes _1, _2, ... (default TRUE).}

\item{include_date}{If TRUE, appends the date to the file name: _YYYYMMDD (default FALSE).}

\item{date_format}{Date format (default "\%Y\%m\%d").}

\item{use_cairo}{Prefer using Cairo for PDF/EPS (default TRUE).}

\item{use_ragg}{Prefer using ragg for PNG/JPG when available (default TRUE).}

\item{quiet}{Suppress messages from ggsave when supported (default TRUE).}

\item{...}{Passed to ggplot2::ggsave() (and therefore to the underlying graphics devices when applicable).}
}
\value{
Named (invisible) vector with the paths of the saved files.
}
\description{
Unified function to save ggplot objects in one or more formats.
}
