% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipdwInterp.R
\name{ipdwInterp}
\alias{ipdwInterp}
\title{Inverse Distance Weighting with custom distances}
\usage{
ipdwInterp(
  sf_ob,
  rstack,
  paramlist,
  overlapped = FALSE,
  yearmon = "default",
  removefile = TRUE,
  dist_power = 1,
  trim_rstack = FALSE
)
}
\arguments{
\item{sf_ob}{sf object with point geometries}

\item{rstack}{RasterStack of path distances}

\item{paramlist}{character. String representing parameter names}

\item{overlapped}{logical. Default is FALSE, specify TRUE if some points lie on top of barriers}

\item{yearmon}{character. String specifying the name of the sf object}

\item{removefile}{logical. Remove files after processing?}

\item{dist_power}{numeric. Distance decay power (p)}

\item{trim_rstack}{logical. Trim the raster stack by the convex hull of sf_ob}
}
\value{
RasterLayer
}
\description{
This function takes a rasterstack of pathdistances and generates surfaces by weighting parameter values by these distances
}
\details{
Under the hood, this function evaluates:
\deqn{V = \frac{\sum\limits_{i=1}^n v_i \frac{1}{d_i^p}}{\sum\limits_{i=1}^n \frac{1}{d_i^p}}}
where \code{d} is the distance between prediction and measurement points,
\code{v_i} is the measured parameter value, and \code{p} is a power parameter.
}
\examples{
library(sf)
sf_ob <- data.frame(rnorm(2))
xy    <- data.frame(x = c(4, 2), y = c(8, 4))
sf_ob <- st_as_sf(cbind(sf_ob, xy), coords = c("x", "y"))

m <- matrix(NA, 10, 10)
costras <- raster(m, xmn = 0, xmx = ncol(m), ymn = 0, ymx = nrow(m))

# introduce spatial gradient
costras[] <- runif(ncell(costras), min = 1, max = 10)
for (i in 1:nrow(costras)) {
  costras[i, ] <- costras[i, ] + i
  costras[, i] <- costras[, i] + i
}

rstack <- pathdistGen(sf_ob, costras, 100, progressbar = FALSE)
final.raster <- ipdwInterp(sf_ob, rstack, paramlist = c("rnorm.2."), overlapped = TRUE)
plot(final.raster)
plot(sf_ob, add = TRUE)
}
