% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-metadata_uk_2010.R
\docType{data}
\name{metadata_uk_2010}
\alias{metadata_uk_2010}
\title{Multipliers and Effects (Product) for Testing}
\format{
A data frame with 10 variables:
\describe{
\item{variable}{A constant used by \code{\link[=iotable_get]{iotable_get()}}.}
\item{uk_row}{Row identifiers from the UK tables. Dots and \code{&} were
converted to \code{-}.}
\item{uk_col}{Column identifiers from the UK tables. Dots and \code{&} were
converted to \code{-}.}
\item{uk_row_label}{Original UK row labels.}
\item{uk_col_label}{Original UK column labels.}
\item{eu_prod_na}{Eurostat vocabulary equivalent of \code{uk_row}.}
\item{row_order}{Ordering key for rows.}
\item{col_order}{Ordering key for columns.}
\item{prod_na}{Eurostat-like key values for rows.}
\item{induse}{Eurostat-like key values for columns.}
}
}
\usage{
metadata_uk_2010
}
\description{
A reference dataset derived from the \strong{United Kingdom Input–Output
Analytical Tables, 2010}. This version was imported from Excel and
reformatted for internal testing.
}
\details{
This dataset provides a mapping between the UK 2010 analytical input–output
tables and Eurostat-compatible codes, intended mainly for testing and
validation.
}
\seealso{
Other metadata datasets: 
\code{\link{employment_metadata}},
\code{\link{metadata}}
}
\concept{metadata datasets}
\keyword{datasets}
