% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recalculate_httk_pbtk_params.R
\name{recalculate_httk_pbtk_params}
\alias{recalculate_httk_pbtk_params}
\title{Recalculating parameters for `httk`'s pbtk or gas_pbtk model}
\usage{
recalculate_httk_pbtk_params(params, dtxsid, species, held_param = NULL)
}
\arguments{
\item{params}{A list of parameter = value pairs that will be used in calculations.}

\item{dtxsid}{The DTXSID of a chemical, by default taken from the 'Chemical' column in the data.}

\item{species}{The species of a subject, by default taken from the 'Species' column in the data.}

\item{held_param}{A character vector or length 1. Either "Krbc2pu" or "Funbound.plasma",
used to determine the conditional calculation of the parameter Kint. When NULL
(default) it will skip the recalculation entirely (as it should when outside fitting
process).}
}
\value{
An updated list of parameters
}
\description{
This set of functions recalculates the parameters that change with each new
set of Funbound.plasma and Clint values. In summary these are:
metabolic clearance (Clmetabolismc), red blood cell partitioning coefficient
(krbc2pu), blood-to-plasma ratio (Rblood2plasma), and fraction absorbed by
the gut (Fabsgut).
}
\section{Clmetabolismc}{

The formula to recalculate this parameters is as follows:
\deqn{Clmetabolismc = Clint\times million.cells.per.gliver\times Vliverc\times
\frac{10^3g}{kg}\times liver.density\times Funbound.plasma\times
\frac{60min}{hr}\times \frac{L}{10^6\mu L}}

Note that because Clmetabolismc is in \eqn{\frac{\mu L}{min\cdot 10^6 cells}},
Vliverc is in \eqn{\frac{L}{kg\ BW}} and liver.density is in \eqn{\frac{kg}{L}},
there are some unit conversions included to give final units in
\eqn{\frac{L}{hr\cdot kg\ BW}}
}

\section{Krbc2pu}{

The formula to recalculate this parameter is as follows:
\deqn{Krbc2pu = Fint\times Kint\times KAPPAcell2pu\times Fcell\times Kcell}
where Fint, Fcell, and Kcell are taken or calculated from values in [httk::tissue.data],
and KAPPAcell2pu is estimated once during [httk::calc_ionization()] and
[httk::parameterize_schmitt()].
\deqn{Kint = (1 - Fprotein.plasma + \left(\frac{0.37}{Funbound.plasma - (1-Fprotein.plasma)}\right)}
Because only Kint needs to be recalculated, the rest is saved as a summary
constant called KFsummary and the other additional parameter included is Fprotein.plasma.
}

\section{Rblood2plasma}{

The formula to calculate this parameter is:
\deqn{Rblood2plasma = 1 - hematocrit + (hematocrit\times krbc2pu\times Funbound.plasma)}
}

\section{Fabsgut}{

The formula to calculate this parameter is:
\deqn{Fabsgut = fabs.oral\times fgut.oral}
where
\deqn{fabs.oral = \mathrm{min}(1, 1 - \left(1 + 2\times peff \times \frac{MRT\times Rsi}{7}
\times \frac{60}{10^4}\right)^{-7})}

\deqn{fgut.oral = \mathrm{min}(1,
\frac{Qgut}{Qgut + \left(Funbound.plasma\times \frac{Clmetabolismc\times BW}{100}\right)}\times
\frac{Qgut}{Qintesttransport + Qgut})}
and
\deqn{Qgut = \frac{Qvilli\times CLperm}{Qvilli + CLperm}}
\deqn{Qvilli = Qvillif\times Qsif\times Qgutf\times Qcardiacc\times BW^{3/4}}
\deqn{CLperm = p_{eff}\times Asi\times \left(\frac{1000}{10^4}\times 100\times 3600\right)}
\deqn{p_{eff} = 10^{0.4926\times \mathrm{log10}(Caco2.Pab) - 0.1454} \text{ and }
\frac{p_{eff} + 1.815}{1.039}\text{ when Species == "rat"}}
\deqn{Asi = 0.66\times BW/70 \text{ or } 71/100^2 \text{ when Species == "rat"}}
\deqn{Qintesttransport = 0.1\times\left(\frac{BW}{70}\right)^{3/4}}
}

\section{Optimizing `Funbound.plasma` or `Krbc2pu`}{

If partitioning coefficients are optimized, Funbound.plasma will be estimated
from given Krbc2pu. This conditional calculation is done by testing whether
Funbound.plasma (given by the previous `Kint` and `KFsummary` parameters) has
changed (reassigned a new value by the optimizer). If so, then the
`Krbc2pu` will be re-calculated.
}

