% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_methods_fold_error.R
\name{fold_error.pk}
\alias{fold_error.pk}
\title{Fold errors}
\usage{
\method{fold_error}{pk}(
  obj,
  newdata = NULL,
  model = NULL,
  method = NULL,
  exclude = TRUE,
  sub_pLOQ = TRUE,
  suppress.messages = NULL,
  ...
)
}
\arguments{
\item{obj}{A `pk` object}

\item{newdata}{Optional: A `data.frame` with new data for which to compute
fold errors. If NULL (the default), then fold errors will be computed for
the data in `obj$data`. `newdata` is required to contain at least the
following variables: `Time`, `Dose`, `Route`, and `Media`.}

\item{model}{Optional: Specify one or more of the fitted models for which to
make predictions and calculate fold errors. If NULL (the default), fold
errors will be returned for all of the models in `obj$stat_model`.}

\item{method}{Optional: Specify one or more of the [optimx::optimx()] methods
for which to make predictions and calculate RMSEs. If NULL (the default),
fold errors will be returned for all of the models in
`obj$pk_settings$optimx$method`.}

\item{exclude}{Logical: `TRUE` to return `NA_real_` for any observations in
the data marked for exclusion (if there is a variable `exclude` in the
data, an observation is marked for exclusion when `exclude %in% TRUE`).
`FALSE` to return the prediction for each observation, regardless of
exclusion. Default `TRUE`.}

\item{sub_pLOQ}{Logical: whether or not to include predictions below pLOQ.
when TRUE, values below pLOQ will be replaced by pLOQ.}

\item{suppress.messages}{Logical: whether to suppress message printing. If
NULL (default), uses the setting in
`object$pk_settings$preprocess$suppress.messages`}

\item{...}{Additional arguments. Currently not in use.}
}
\value{
A data.frame with one row for each `data_group`, `model` and
  `method`. A column contains the fold errors (observed/predicted) of the
  model fitted by the corresponding method. These residuals are
  concentrations in the same units as `obj$data$Conc.Units`; any
  concentration transformations (in `obj$scale$conc`) are *not* applied.
}
\description{
Calculate fold errors for a fitted `pk` object.
}
\details{
Here, fold error is defined as `observed/predicted`.

# Scaling and transformation of concentration variables in `newdata`

This function differs from some of the other methods for a fitted [pk()]
object that accept `newdata`, in that there is no `use_scale_conc` argument
for [fold_error.pk()]. Fold errors are always computed on the natural,
un-transformed concentration scale (but note that fold error on a dose-normalized
scale will be the same as fold error on a non-dose-normalized scale).
}
\author{
Caroline Ring
}
