% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hessian_funs.R
\name{calc_sds_alerts}
\alias{calc_sds_alerts}
\title{Calculate parameter SDs}
\usage{
calc_sds_alerts(
  pars_opt,
  pars_const,
  observations,
  modelfun,
  dose_norm,
  log10_trans
)
}
\arguments{
\item{pars_opt}{Named numeric: A vector of parameter values for the
parameters that were optimized. For example, you can get this using
[coef.pk()] with `include_type = "optim"`.}

\item{pars_const}{Named numeric: A vector of parameter values for parameters
that were held constant, not optimized (but are necessary to evaluate the
model). For example, you can get this using [coef.pk()] with `include_type
= "const"`.}

\item{observations}{The data used to fit the model. For example, you can get
this using [get_data.pk()].}

\item{modelfun}{The name of the function that evaluates the model (passed to
[log_likelihood()]).}

\item{dose_norm}{Logical: Whether to dose-normalize concentrations before
evaluating log-likelihood. Passed to [log_likelihood()].}

\item{log10_trans}{Logical: Whether to log10-transform concentrations before
evaluating log-likelihood. Passed to [log_likelihood()].}
}
\value{
A data.frame with variables `param_name`, `param_sd`, and `sd_alert`,
  and as many rows as the length of `pars_opt`. `param_name` contains the
  names of `pars_opt`. `param_sd` contains the parameter standard deviations
  calculated using the inverse Hessian. `sd_alerts` is a character variable
  noting any errors encountered while attempting to calculate the parameter
  SDs.
}
\description{
Calculate parameter SDs using inverse Hessian
}
\details{
Calculate parameter SDs using inverse Hessian approach for a single set of
parameter values for a single model and a single data set.

This is a workhorse function called by [coef_sd.pk()].
If the length of this vector is \eqn{n}, the Hessian matrix will be
\eqn{n \times n}.

The coefficient standard deviations are estimated by computing a numerical
approximation to the model Hessian (the matrix of second derivatives of the
model objective function with respect to each model parameter) and then
attempting to invert it. This procedure yields a variance/covariance matrix
for the model parameters. The square root of the diagonal elements of this
matrix represent the parameter standard deviations.

A first attempt is made to invert the Hessian using [solve()] (see
[hess_sd1()]). If the Hessian is singular, an attempt is made to calculate a
pseudovariance matrix, following the procedure outlined in Gill & King (2004)
(see [hess_sd2()]). First, the generalized inverse of the Hessian is
calculated using [MASS::ginv()]. Then, a generalized Cholesky decomposition
(to ensure positive-definiteness) is calculated using [Matrix::Cholesky] with
argument `perm = TRUE`. The generalized inverse is reconstructed from the
generalized Cholesky factorization. The square root of the diagonal elements of this matrix
represent the parameter standard deviations.

If neither of these procedures is successful, then `NA_real_` is returned for
all coefficient standard deviations. Record any error messages encountered
during the process, and note which method was used to produce the final
results. This is a workhorse function called by [coef_sd.pk()].
}
\references{
Gill J, King G. (2004) What to Do When Your Hessian is Not
  Invertible: Alternatives to Model Respecification in Nonlinear Estimation.
  Sociological Methods & Research 33(1):54-87. DOI: 10.1177/0049124103262681
}
\author{
Caroline Ring
}
