% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgname.R
\docType{package}
\name{intkrige-package}
\alias{intkrige-package}
\alias{_PACKAGE}
\title{INTERVAL-VALUED KRIGING MODELS IN R}
\description{
An interval-valued extension of ordinary and simple kriging.
    Optimization of the function is based on a generalized interval distance.
    This creates a non-differentiable cost function that requires a
    differentiable approximation to the absolute value function. This
    differentiable approximation is optimized using a Newton-Raphson algorithm
    with a penalty function to impose the constraints. Analyses in the package
    are driven by the 'intsp' and 'intgrd' 
    classes, 
    which are interval-valued extensions of
    'SpatialPointsDataFrame' and 'SpatialPixelsDataFrame' respectively. 
    The package includes several wrappers to functions in the 
    'gstat' and 'sp' packages.
}
\section{Functions}{

The package contains several generic functions such as
 \code{\link[=plot,intsp,missing-method]{plot}},
 \code{\link[=print.intsp]{print}},
 and \code{\link[=summary.intsp]{summary}} to facilitate
 interval-valued analysis. In addition to these functions,
 the package also contains the following functions:

\itemize{
\item \code{\link{intkrige}} Make predictions on
 interval-valued spatial data using interval-valued kriging.
\item \code{\link{interval<-}} Create an interval-valued spatial object.
\item \code{\link{intvariogram}} Simultaneously calculate the empirical variograms
 for an interval-valued spatial object.
\item \code{\link{fit.intvariogram}} Automatically fit theoretical variograms to
 empirical variograms obtained from interval-valued spatial objects.
\item \code{\link{intvCheck}} Visualize the variogram fits for interval-valued
 spatial objects.
\item \code{\link{dist_cpp}} A c++ function to calculate great circle
 or Euclidean distances.
}
}

\section{Data}{

\itemize{
\item \link{utsnow} An interval-valued design ground snow load dataset for Utah.
\item \link{ohtemp} An interval-valued 30 year mean temperature dataset for the
 Ohio River Basin.
\item \link{ohMap} A \code{\link[sp:SpatialPolygons]{SpatialPolygons}}
  shapefile for the Ohio River Basin.
}
}

\author{
Brennan Bean \email{brennan.bean.20@gmail.com}
}
