% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slider.R
\name{inline_slider}
\alias{inline_slider}
\title{Inline slider input}
\usage{
inline_slider(
  id,
  value,
  min,
  max,
  step = NULL,
  default = value,
  placeholder = "Enter number",
  meaning = NULL
)
}
\arguments{
\item{id}{The \code{input} slot that will be used to access the value.}

\item{value}{The initial number.}

\item{min, max}{Minimum and maximum values. Both are required.}

\item{step}{A step value that the slider will use to jump between values
between min and max.}

\item{default}{A default value to be used if the input is invalid or empty.}

\item{placeholder}{The character string or HTML element that will appear in
the textbox when it is empty, as a prompt.}

\item{meaning}{A descriptive label, for people using assistive technology
such as screen readers.}
}
\value{
An inline widget to be included in an \code{\link[=inline]{inline()}} wrapper.
}
\description{
A numeric input with a slider pop-up similar to \code{\link[shiny:sliderInput]{shiny::sliderInput()}} that
can be included in an \code{\link[=inline]{inline()}} wrapper.
}
\examples{
ui <- bslib::page_fixed(
    shiny::h1("Pep talk"),
    inline("When you go out there tonight, give ",
        inline_slider("amount", 10, 0, 110, step = 1, default = 50,
            placeholder = "Enter a percentage.", meaning = "Percent to give"),
        "\%.")
)
}
\seealso{
\link[shiny:sliderInput]{shiny::sliderInput} for how the slider input works with your Shiny server.
}
