% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{trim}
\alias{trim}
\title{Trim primer and/or index sequences.}
\usage{
trim(x, up, down = NULL)
}
\arguments{
\item{x}{a "DNAbin" object or a vector of concatenated upper-case character strings,
containing the sequences to be trimmed.}

\item{up, down}{"DNAbin" objects or vectors of concatenated upper-case character strings,
representing the primer sequences.}
}
\value{
a "DNAbin" object or a vector of concatenated character strings,
  depending on the input.
}
\description{
This function trims the primer and/or index sequence(s) from a set of DNA sequences.
}
\details{
Any sequences not containing the primer(s) in either direction are discarded.
  Hence this function can also be used to de-multiplex sequences and remove indices,
  though it will generally be faster to do this on the sequencing platform prior to
  exporting the FASTQ files.
}
\examples{
\donttest{
  ## download and extract example FASTQ file to temporary directory
  td <- tempdir()
  URL <- "https://www.dropbox.com/s/71ixehy8e51etdd/insect_tutorial1_files.zip?dl=1"
  dest <- paste0(td, "/insect_tutorial1_files.zip")
  download.file(URL, destfile = dest, mode = "wb")
  unzip(dest, exdir = td)
  x <- readFASTQ(paste0(td, "/COI_sample2.fastq"))
  ## trim primers from sequences
  mlCOIintF <- "GGWACWGGWTGAACWGTWTAYCCYCC"
  jgHCO2198 <- "TAIACYTCIGGRTGICCRAARAAYCA"
  x <- trim(x, up = mlCOIintF, down = jgHCO2198)
}
}
\author{
Shaun Wilkinson
}
