% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.mrsea.R
\docType{data}
\name{mrsea}
\alias{mrsea}
\title{Marine renewables strategic environmental assessment}
\format{
A list of objects:
\describe{
\item{\code{points}}{ A \code{sf} object containing the locations of
XXXXX.}
\item{\code{samplers}}{ A \code{sf} object containing the transect lines
that were surveyed.}
\item{\code{mesh}}{ An \code{fm_mesh_2d} object containing a Delaunay triangulation
mesh (a type of discretization of continuous space) covering the survey
region.}
\item{\code{boundary}}{ An \code{sf} object defining the boundary polygon of the
survey region.}
\item{\code{covar}}{ An \code{sf} containing sea depth estimates.}
}
}
\source{
Library \code{MRSea}.
}
\usage{
mrsea
}
\description{
Data imported from package MRSea, see
\url{https://www.creem.st-andrews.ac.uk/software/}
}
\examples{
if (require(ggplot2, quietly = TRUE)) {
  ggplot() +
    geom_fm(data = mrsea$mesh) +
    gg(mrsea$samplers) +
    gg(mrsea$points) +
    gg(mrsea$boundary)
}
}
\references{
NONE YET
}
\keyword{datasets}
