% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_covid_stats_for_state.R
\name{get_covid_stats_for_state}
\alias{get_covid_stats_for_state}
\title{Get COVID-19 Statistics for Specific US State(s)}
\usage{
get_covid_stats_for_state(states, yesterday = FALSE, allowNull = FALSE)
}
\arguments{
\item{states}{A character string with the name of a U.S. state or a comma-separated list of state names. Names must be spelled correctly.}

\item{yesterday}{Logical. If \code{TRUE}, returns data from the previous day. Default is \code{FALSE}.}

\item{allowNull}{Logical. If \code{TRUE}, missing values are returned as \code{NA} instead of \code{0}. Default is \code{FALSE}.}
}
\value{
A data frame containing the following columns:
\itemize{
  \item \code{state}: State name.
  \item \code{updated}: Last updated timestamp (converted to human-readable datetime in UTC).
  \item \code{cases}: Total confirmed cases.
  \item \code{todayCases}: New confirmed cases today.
  \item \code{deaths}: Total deaths.
  \item \code{todayDeaths}: New deaths today.
  \item \code{population}: State population estimate.
}
}
\description{
Retrieves real-time COVID-19 totals for one or more U.S. states from the 'disease.sh' API.
}
\details{
This function sends a GET request to the 'disease.sh' API for COVID-19 statistics in one or more U.S. states.
If multiple states are passed, they must be comma-separated and correctly spelled.
The 'updated' field is returned in milliseconds and is converted to a POSIXct datetime.
}
\note{
Requires an internet connection.
}
\examples{
\donttest{
# Retrieve COVID-19 data for California
ca <- get_covid_stats_for_state("California")

# Retrieve yesterday's data for New York and Texas
ny_tx <- get_covid_stats_for_state("New York,Texas", yesterday = TRUE)
}

}
\references{
API Docs: https://disease.sh/docs/#/COVID-19%3A%20Worldometers/get_v3_covid_19_states__states_
}
