% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{get_metadata_classifications}
\alias{get_metadata_classifications}
\title{Get all available classifications}
\usage{
get_metadata_classifications(
  operation = NULL,
  lang = "ES",
  validate = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{operation}{(string): Code of the operation. Provide code to get all
the classifications for the given operation. To obtain a list of
available operations see \code{\link[=get_metadata_operations]{get_metadata_operations()}}.
If no operation is specified then all the classifications will be shown.}

\item{lang}{(string): language of the retrieved data. Set to 'ES' for Spanish or set to 'EN' for English.}

\item{validate}{(logical): validate input parameters. A FALSE value means fewer API calls.}

\item{verbose}{(logical): print additional information, including the URL to call the API service.}
}
\value{
Data frame with information of the available classifications
}
\description{
Get all available classifications
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get all classifications
df <- get_metadata_classifications()
head(df)

# Get classifications for a specific operation
df <- get_metadata_classifications(operation = "IPC", validate = FALSE)
head(df)
\dontshow{\}) # examplesIf}
}
