% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{delete_vertex_attr}
\alias{delete_vertex_attr}
\title{Delete a vertex attribute}
\usage{
delete_vertex_attr(graph, name)
}
\arguments{
\item{graph}{The graph}

\item{name}{The name of the vertex attribute to delete.}
}
\value{
The graph, with the specified vertex attribute removed.
}
\description{
Delete a vertex attribute
}
\examples{
g <- make_ring(10) \%>\%
  set_vertex_attr("name", value = LETTERS[1:10])
vertex_attr_names(g)
g2 <- delete_vertex_attr(g, "name")
vertex_attr_names(g2)
}
\seealso{
Vertex, edge and graph attributes
\code{\link{delete_edge_attr}()},
\code{\link{delete_graph_attr}()},
\code{\link{edge_attr}()},
\code{\link{edge_attr<-}()},
\code{\link{edge_attr_names}()},
\code{\link{graph_attr}()},
\code{\link{graph_attr<-}()},
\code{\link{graph_attr_names}()},
\code{\link{igraph-attribute-combination}},
\code{\link{igraph-dollar}},
\code{\link{igraph-vs-attributes}},
\code{\link{set_edge_attr}()},
\code{\link{set_graph_attr}()},
\code{\link{set_vertex_attr}()},
\code{\link{set_vertex_attrs}()},
\code{\link{vertex_attr}()},
\code{\link{vertex_attr<-}()},
\code{\link{vertex_attr_names}()}
}
\concept{attributes}
