% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-rgl-grid.R, R/plot-rgl-facelayer.R
\name{faces3d}
\alias{faces3d}
\alias{faces3d,trigrid-method}
\alias{faces3d,hexagrid-method}
\alias{faces3d,facelayer-method}
\title{Methods of 3D face plotting.}
\usage{
faces3d(x, ...)

\S4method{faces3d}{trigrid}(x, ...)

\S4method{faces3d}{hexagrid}(x, ...)

\S4method{faces3d}{facelayer}(x, col = "heat", breaks = NULL, inclusive = TRUE, legend = TRUE, ...)
}
\arguments{
\item{x}{The \code{\link{trigrid}}, \code{\link{hexagrid}} or \code{\link{facelayer}} object to be plotted.}

\item{...}{Further graphical parameters passed to (see \code{\link[rgl]{plot3d}}) and the \code{\link{heatMapLegend}} function.}

\item{col}{(\code{character}) Graphical parameter indicating the colours of the faces. A single value is accepted for \code{logical} values. Multiple colors will be passed to \code{\link[grDevices:colorRamp]{colorRampPalette}}, to create palettes for heat maps in case of \code{numeric} values. The default plotting method in this case is the reversed \code{\link[grDevices:palettes]{heat.colors}}. In case of categorical data, random colors will be chosen.}

\item{breaks}{(\code{numeric}) Vector stating the breakpoints between the plotted levels. The argument is passed to the \code{\link[base]{cut}} function.}

\item{inclusive}{(\code{logical}): If there are values beyond the limits of breaks, should these be represented in the plot (\code{TRUE}) or left out completely \code{FALSE}?}

\item{legend}{(\code{logical}) Should the heatmap legend be plotted?}
}
\value{
The function does not return any value.
}
\description{
This function is used to plot the faces of either a \code{\link{trigrid}}, \code{\link{hexagrid}} or \code{\link{facelayer}} object in 3D space.
}
\details{
The function is built on the openGL renderer of the R package \code{rgl}.
}
\examples{
# create a hexagonal grid
    g <- hexagrid(c(2,2))
# plot the grid in 3d space
# faces3d(g)
h <- hexagrid(8)
b <- facelayer(h)
values(b)<- rnorm(length(b))
}
