% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothmsm.R
\name{smoothmsm}
\alias{smoothmsm}
\title{Smooth hazard estimation for general multi-state model with interval censored
transitions}
\usage{
smoothmsm(
  gd,
  tmat,
  exact,
  formula,
  data,
  deg_splines = 3,
  n_segments = 20,
  ord_penalty = 2,
  maxit = 100,
  tol = 1e-04,
  Mtol = 1e-04,
  conv_crit = c("haz", "prob", "lik"),
  verbose = FALSE,
  prob_tol = tol/10,
  ode_solver = "lsoda",
  ridge_penalty = 1e-06
)
}
\arguments{
\item{gd}{A \code{data.frame} with the following named columns
\describe{
  \item{\code{id}:}{Subject idenitifier;}
  \item{\code{state}:}{State at which the subject is observed at \code{time};}
  \item{\code{time}:}{Time at which the subject is observed;}
} The true transition time between states is then interval censored between the times.}

\item{tmat}{A transition matrix as created by \code{\link[mstate:transMat]{transMat}}}

\item{exact}{Numeric vector indicating to which states transitions are observed at exact times.
Must coincide with the column number in \code{tmat}.}

\item{formula}{Formula to interpret in data for covariates.}

\item{data}{A \code{data.frame} containing a column called \code{'id'} 
(identifying the subjects in \code{gd}) and 
variables which to interpret in \code{formula}.}

\item{deg_splines}{Degree to use for the B-spline basis functions. Defaults 
to 3 (cubic B-splines).}

\item{n_segments}{Number of segments to use for the P-splines. The
segments will space the domain evenly. According to Eilers & Marx (2021), it 
it OK to choose this number very large. Default = 20.}

\item{ord_penalty}{Order of the P-spline penalty (penalty on the difference 
between d-order differences of spline coefficients). See Eilers & Marx 
Section 2.3. Defaults to 2.}

\item{maxit}{Maximum number of iterations. Default = 100.}

\item{tol}{Tolerance of the convergence procedure in the E-step. A change in the value of 
\code{conv_crit} in an iteration of less than \code{tol} will make the procedure stop.}

\item{Mtol}{Tolerance of the convergence procedure of the M-step. The M-step 
consists of an Iteratively Reweighted Least Squares (IRLS) procedure, where 
the (unobserved) complete-data likelihood is maximized. Default is \code{1e-4}.}

\item{conv_crit}{Convergence criterion. Stops procedure when the difference 
in the chosen quantity between two consecutive iterations is smaller 
than the tolerance level \code{tol}. One of the following:
\describe{
\item{"haz"}{Stop when change in maximum estimated intensities (hazards) \code{ < tol}.}
\item{"prob"}{Stop when change in estimated probabilities \code{ < tol}.}
\item{"lik"}{Stop when change in observed-data likelihood \code{ < tol}.}
} Default is "haz". The options "haz" and "lik" can be compared across different
\code{method}s, but "prob" is dependent on the chosen \code{method}. Most 
conservative (requiring most iterations) is "prob", followed by "haz" and finally "lik".}

\item{verbose}{Should iteration messages be printed? Default is FALSE}

\item{prob_tol}{If an estimated probability is smaller than \code{prob_tol}, 
it will be set to zero during estimation. Default value is \code{tol/10}.}

\item{ode_solver}{The integrator to use for solving the ODE's. See 
\code{\link[deSolve:ode]{ode()}}. By default, the "lsoda" solver will be used.}

\item{ridge_penalty}{The ridge penalty to use for estimating risk-adjustment 
coefficients. Default = 1e-06.}
}
\description{
For a general Markov chain multi-state model with interval censored 
transitions calculate the NPMLE of the transition intensities. The estimates 
are returned as an \code{\link[mstate:msfit]{msfit}} object. The smallest time 
in the data will be set to zero.
}
\references{
Eilers, P.H.C. and Marx, B.D., Practical Smoothing: The Joys of P-splines, 
Cambridge University Press (2021)
}
