% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calmarFunctions.R
\name{calibrationMarginStats}
\alias{calibrationMarginStats}
\title{Stats for initial weights, calibrated weights, and margins.}
\usage{
calibrationMarginStats(
  data,
  marginMatrix,
  popTotal = NULL,
  pct = FALSE,
  colWeights,
  colCalibratedWeights = NULL,
  calibThreshold = 1
)
}
\arguments{
\item{data}{dataframe containing the survey data}

\item{marginMatrix}{matrix of margins}

\item{popTotal}{total of population, useful if margins are entered in relative value}

\item{pct}{Set this to true if margins for categorical variables are written in percentages}

\item{colWeights}{name of weights column in the dataframe}

\item{colCalibratedWeights}{name of calibrated weights column in the dataframe (if applicable)}

\item{calibThreshold}{If difference between calibration estimate and margin differ more than
this parameter, calibration is considered to have failed}
}
\value{
List containing stats on weights and margins
}
\description{
Gives stats about the calibration process: differences between 
totals after/before calibration and margins. Totals for categorical
variables are displayed in percentages.
(same as first panels output in Calmar/Calmar 2)
Output is a list, which might not be convenient for exports (e.g. for integration
into a scientific report). In such cases,
use function \code{\link{marginStats}}, which outputs a dataframe.
}
\seealso{
\code{\link{marginStats}}
}
