% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_correct_annotation.R
\name{ifcb_correct_annotation}
\alias{ifcb_correct_annotation}
\title{Correct Annotations in MATLAB Classlist Files}
\usage{
ifcb_correct_annotation(
  manual_folder,
  out_folder,
  correction = NULL,
  correct_classid,
  do_compression = TRUE,
  correction_file = deprecated()
)
}
\arguments{
\item{manual_folder}{A character string specifying the path to the folder containing the original MAT classlist files to be updated.}

\item{out_folder}{A character string specifying the path to the folder where updated MAT classlist files will be saved.}

\item{correction}{Either a character string specifying the path to the correction file, or a character vector containing image filenames to be corrected.
If a file is provided, it should have a column named \code{image_filename}. If a character vector is provided, it will be treated as a direct list of image filenames.}

\item{correct_classid}{An integer specifying the class ID to use for corrections.}

\item{do_compression}{A logical value indicating whether to compress the .mat file. Default is TRUE.}

\item{correction_file}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \code{correction} instead.}
}
\value{
This function does not return any value; it updates the classlist files in the specified output directory.
}
\description{
This function corrects annotations in MATLAB classlist files located in a specified manual folder,
generated by the code in the \code{ifcb-analysis} repository (Sosik and Olson 2007).
It replaces the class ID of specified regions of interest (ROIs) in the classlist files based on
a correction file or a character vector.
}
\details{
Python must be installed to use this function. The required python packages can be installed in a virtual environment using \code{ifcb_py_install()}.

The correction file is expected to contain at least one column: \code{image_filename}, which includes the filenames of the images (with or without additional trailing information).
The function processes each file, corrects the annotations, and saves the updated files in the output folder.

If a character vector is provided as \code{correction}, it will be used directly as a list of filenames for correction.

The \code{correction} is typically generated using a Shiny app that provides an interactive interface for browsing and managing
IFCB (Imaging FlowCytobot) image galleries. This Shiny app can be initialized using the function \code{ifcb_run_image_gallery()}.
}
\examples{
\dontrun{
# Initialize a python session if not already set up
ifcb_py_install()

# Correct class ID in .mat classlist files using a correction file
ifcb_correct_annotation("input/manual",
                        "output/manual",
                        "corrections.txt",
                        99)

# Correct class ID in .mat classlist files using a character vector of filenames
ifcb_correct_annotation("input/manual",
                        "output/manual",
                        c("D20230917T153755_IFCB134_01724.png",
                          "D20230917T110059_IFCB134_00380.png"),
                        99)
}

}
\references{
Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.
}
\seealso{
\code{\link{ifcb_py_install}} \url{https://github.com/hsosik/ifcb-analysis}
}
