% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_hep_clearance.R
\name{calc_hep_clearance}
\alias{calc_hep_clearance}
\title{Calculate the hepatic clearance.}
\usage{
calc_hep_clearance(
  chem.name = NULL,
  chem.cas = NULL,
  dtxsid = NULL,
  parameters = NULL,
  hepatic.model = "well-stirred",
  suppress.messages = FALSE,
  well.stirred.correction = TRUE,
  restrictive.clearance = TRUE,
  species = "Human",
  adjusted.Funbound.plasma = TRUE,
  ...
)
}
\arguments{
\item{chem.name}{Either the chemical name, CAS number, or the parameters
must be specified.}

\item{chem.cas}{Either the chemical name, CAS number, or the parameters must
be specified.}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Chemical parameters from parameterize_steadystate
function, overrides chem.name and chem.cas.}

\item{hepatic.model}{Model used in calculating hepatic clearance, unscaled,
parallel tube, dispersion, or default well-stirred.}

\item{suppress.messages}{Whether or not to suppress the output message.}

\item{well.stirred.correction}{Uses the \insertCite{yang2007misuse}{httk} 
blood:plasma ratio correction in the calculation of hepatic
clearance for well-stirred model if TRUE if argument hepatic.model =
"well-stirred".}

\item{restrictive.clearance}{If TRUE (default)
the rate of metabolism is restricted
to the unbound fraction of chemical. If FALSE the free fraction is set to 1
(that is, plasma protein binding is weak
and metabolzied chemical is rapidly replaced)}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{adjusted.Funbound.plasma}{Uses the 
\insertCite{pearce2017evaluation}{httk} lipid binding adjustment
for Funbound.plasma (which also impacts partition coefficients such as 
blood:plasma ratio) when set to TRUE (Default).}

\item{...}{Additional parameters passed to parameterize_steadystate if
parameters is NULL.}
}
\value{
\item{Hepatic Clearance}{Units of L/h/kg BW.}
}
\description{
This function calculates the hepatic clearance in plasma for using the
"well-stirred" model by default. Other scaling options from 
\insertCite{ito2004comparison}{httk} are also available.
Parameters for scaling from flow-free intrinsic-hepatic clearance to 
whole-liver metabolism rate are taken from 
\insertCite{carlile1997scaling}{httk}.
In vitro measured hepatic clearace is 
corrected for estimated binding in the in vitro clearance assay 
using the model of \insertCite{kilford2008hepatocellular}{httk}.
The agument restrictive.clearance (defaults to TRUE) describes the
significance (or lack thereof) of plasma protein binding in metabolism. 
Restrictive clearance assumes that only the free fraction of chemical in
plasma is available for metabolism. 
Non-restrictive clearance assumes that the compound is weakly bound to
plasma protein and any free chemical metabolized is instantly
replaced. For non-restrictive clearance the effective fup = 1.
}
\examples{

calc_hep_clearance(chem.name="Ibuprofen",hepatic.model='unscaled')
\donttest{
calc_hep_clearance(chem.name="Ibuprofen",well.stirred.correction=FALSE)
}
}
\references{
\insertAllCited{}
}
\author{
John Wambaugh and Robert Pearce
}
\keyword{Parameter}
