% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-marray-replace.r,
%   R/method-marray-subsetting.r, R/method-mmatrix-replace.r,
%   R/method-mvector-replace.r, R/method-subsetting.r
\name{extract}
\alias{extract}
\alias{[<-,marray,numeric,numeric,numeric-method}
\alias{[<-,marray,missing,numeric,numeric-method}
\alias{[<-,marray,numeric,missing,numeric-method}
\alias{[<-,marray,missing,missing,numeric-method}
\alias{[<-,marray,numeric,numeric,memoryMapped-method}
\alias{[<-,marray,missing,numeric,memoryMapped-method}
\alias{[<-,marray,numeric,missing,memoryMapped-method}
\alias{[<-,marray,missing,missing,memoryMapped-method}
\alias{[,marray,numeric,numeric-method}
\alias{[,marray,missing,numeric-method}
\alias{[,marray,numeric,missing-method}
\alias{[,marray,missing,missing-method}
\alias{[<-,mmatrix,numeric,numeric,numeric-method}
\alias{[<-,mmatrix,missing,numeric,numeric-method}
\alias{[<-,mmatrix,numeric,missing,numeric-method}
\alias{[<-,mmatrix,missing,missing,numeric-method}
\alias{[<-,mmatrix,numeric,numeric,memoryMapped-method}
\alias{[<-,mmatrix,missing,numeric,memoryMapped-method}
\alias{[<-,mmatrix,numeric,missing,memoryMapped-method}
\alias{[<-,mmatrix,missing,missing,memoryMapped-method}
\alias{[<-,mvector,numeric,missing,numeric-method}
\alias{[<-,mvector,missing,missing,numeric-method}
\alias{[<-,mvector,numeric,missing,memoryMapped-method}
\alias{[<-,mvector,missing,missing,memoryMapped-method}
\alias{[,mmatrix,numeric,numeric-method}
\alias{[,mmatrix,missing,numeric-method}
\alias{[,mmatrix,numeric,missing-method}
\alias{[,mmatrix,missing,missing-method}
\alias{[,mvector,numeric,missing-method}
\alias{[,mvector,missing,missing-method}
\title{Read/write access to memory-mapped objects}
\usage{
\S4method{[}{marray,numeric,numeric,numeric}(x, i, j, ...) <- value

\S4method{[}{marray,missing,numeric,numeric}(x, i, j, ...) <- value

\S4method{[}{marray,numeric,missing,numeric}(x, i, j, ...) <- value

\S4method{[}{marray,missing,missing,numeric}(x, i, j, ...) <- value

\S4method{[}{marray,numeric,numeric,memoryMapped}(x, i, j, ...) <- value

\S4method{[}{marray,missing,numeric,memoryMapped}(x, i, j, ...) <- value

\S4method{[}{marray,numeric,missing,memoryMapped}(x, i, j, ...) <- value

\S4method{[}{marray,missing,missing,memoryMapped}(x, i, j, ...) <- value

\S4method{[}{marray,numeric,numeric}(x, i, j, ..., drop = TRUE)

\S4method{[}{marray,missing,numeric}(x, i, j, ..., drop = TRUE)

\S4method{[}{marray,numeric,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{marray,missing,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{mmatrix,numeric,numeric,numeric}(x, i, j, ...) <- value

\S4method{[}{mmatrix,missing,numeric,numeric}(x, i, j, ...) <- value

\S4method{[}{mmatrix,numeric,missing,numeric}(x, i, j, ...) <- value

\S4method{[}{mmatrix,missing,missing,numeric}(x, i, j, ...) <- value

\S4method{[}{mmatrix,numeric,numeric,memoryMapped}(x, i, j, ...) <- value

\S4method{[}{mmatrix,missing,numeric,memoryMapped}(x, i, j, ...) <- value

\S4method{[}{mmatrix,numeric,missing,memoryMapped}(x, i, j, ...) <- value

\S4method{[}{mmatrix,missing,missing,memoryMapped}(x, i, j, ...) <- value

\S4method{[}{mvector,numeric,missing,numeric}(x, i, j, ...) <- value

\S4method{[}{mvector,missing,missing,numeric}(x, i, j, ...) <- value

\S4method{[}{mvector,numeric,missing,memoryMapped}(x, i, j, ...) <- value

\S4method{[}{mvector,missing,missing,memoryMapped}(x, i, j, ...) <- value

\S4method{[}{mmatrix,numeric,numeric}(x, i, j, ..., drop = TRUE)

\S4method{[}{mmatrix,missing,numeric}(x, i, j, ..., drop = TRUE)

\S4method{[}{mmatrix,numeric,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{mmatrix,missing,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{mvector,numeric,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{mvector,missing,missing}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{x}{memory-mapped object}

\item{i, j}{indices of elements to extract or replace}

\item{...}{supplementary indices (for arrays)}

\item{value}{replacement value}

\item{drop}{for dual matrices or array.}
}
\value{
a R object or a memory-mapped object (depending on \code{houba("max.size")})
}
\description{
Read/write access to memory-mapped objects
}
\examples{
a <- matrix(1:6, 2, 3)
A <- as.mmatrix(a)
A[1,]
A[2,] <- A[1,] * 2
A[,3] <- 6:7
A

}
