% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-dim.r
\name{dim}
\alias{dim}
\alias{dim<-,memoryMapped,numeric-method}
\alias{dim<-,memoryMapped,NULL-method}
\title{Change object dimensions}
\usage{
\S4method{dim}{memoryMapped,numeric}(x) <- value

\S4method{dim}{memoryMapped,NULL}(x) <- value
}
\arguments{
\item{x}{a memory mapped object}

\item{value}{or \code{NULL} new dimensions}
}
\description{
Change object dimensions
}
\details{
The new dimensions must match the object size. This function can
change the class of the object, e.g. from mvector to mmatrix or the reverse.

If the value is \code{NULL}, then \code{x} is turned into a \code{mvector}.
}
\examples{
x <- as.mvector(1:6)
x
dim(x) <- 2:3
x
dim(x) <- NULL
x

}
