% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_player.R
\name{nba_playercareerstats}
\alias{nba_playercareerstats}
\title{\strong{Get NBA Stats API Player Career Stats}}
\usage{
nba_playercareerstats(
  league_id = "00",
  per_mode = "Totals",
  player_id = "2544",
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{per_mode}{Per Mode - PerGame, Totals}

\item{player_id}{Player ID}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: CareerTotalsAllStarSeason,
CareerTotalsCollegeSeason, CareerTotalsPostSeason,
CareerTotalsRegularSeason, SeasonRankingsPostSeason,
SeasonRankingsRegularSeason, SeasonTotalsAllStarSeason, SeasonTotalsCollegeSeason,
SeasonTotalsPostSeason, SeasonTotalsRegularSeason

\strong{SeasonTotalsRegularSeason}\tabular{ll}{
   col_name \tab types \cr
   PLAYER_ID \tab character \cr
   SEASON_ID \tab character \cr
   LEAGUE_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   PLAYER_AGE \tab character \cr
   GP \tab character \cr
   GS \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   TOV \tab character \cr
   PF \tab character \cr
   PTS \tab character \cr
}


\strong{CareerTotalsRegularSeason}\tabular{ll}{
   col_name \tab types \cr
   PLAYER_ID \tab character \cr
   LEAGUE_ID \tab character \cr
   Team_ID \tab character \cr
   GP \tab character \cr
   GS \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   TOV \tab character \cr
   PF \tab character \cr
   PTS \tab character \cr
}


\strong{SeasonTotalsPostSeason}\tabular{ll}{
   col_name \tab types \cr
   PLAYER_ID \tab character \cr
   SEASON_ID \tab character \cr
   LEAGUE_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   PLAYER_AGE \tab character \cr
   GP \tab character \cr
   GS \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   TOV \tab character \cr
   PF \tab character \cr
   PTS \tab character \cr
}


\strong{CareerTotalsPostSeason}\tabular{ll}{
   col_name \tab types \cr
   PLAYER_ID \tab character \cr
   LEAGUE_ID \tab character \cr
   Team_ID \tab character \cr
   GP \tab character \cr
   GS \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   TOV \tab character \cr
   PF \tab character \cr
   PTS \tab character \cr
}


\strong{SeasonTotalsAllStarSeason}\tabular{ll}{
   col_name \tab types \cr
   PLAYER_ID \tab character \cr
   SEASON_ID \tab character \cr
   LEAGUE_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   PLAYER_AGE \tab character \cr
   GP \tab character \cr
   GS \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   TOV \tab character \cr
   PF \tab character \cr
   PTS \tab character \cr
}


\strong{CareerTotalsAllStarSeason}\tabular{ll}{
   col_name \tab types \cr
   PLAYER_ID \tab character \cr
   LEAGUE_ID \tab character \cr
   Team_ID \tab character \cr
   GP \tab character \cr
   GS \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   TOV \tab character \cr
   PF \tab character \cr
   PTS \tab character \cr
}


\strong{SeasonTotalsCollegeSeason}

\strong{CareerTotalsCollegeSeason}

\strong{SeasonTotalsShowcaseSeason}

\strong{CareerTotalsShowcaseSeason}

\strong{SeasonRankingsRegularSeason}\tabular{ll}{
   col_name \tab types \cr
   PLAYER_ID \tab character \cr
   SEASON_ID \tab character \cr
   LEAGUE_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   PLAYER_AGE \tab character \cr
   GP \tab character \cr
   GS \tab character \cr
   RANK_MIN \tab character \cr
   RANK_FGM \tab character \cr
   RANK_FGA \tab character \cr
   RANK_FG_PCT \tab character \cr
   RANK_FG3M \tab character \cr
   RANK_FG3A \tab character \cr
   RANK_FG3_PCT \tab character \cr
   RANK_FTM \tab character \cr
   RANK_FTA \tab character \cr
   RANK_FT_PCT \tab character \cr
   RANK_OREB \tab character \cr
   RANK_DREB \tab character \cr
   RANK_REB \tab character \cr
   RANK_AST \tab character \cr
   RANK_STL \tab character \cr
   RANK_BLK \tab character \cr
   RANK_TOV \tab character \cr
   RANK_PTS \tab character \cr
   RANK_EFF \tab character \cr
}


\strong{SeasonRankingsPostSeason}\tabular{ll}{
   col_name \tab types \cr
   PLAYER_ID \tab character \cr
   SEASON_ID \tab character \cr
   LEAGUE_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   PLAYER_AGE \tab character \cr
   GP \tab character \cr
   GS \tab character \cr
   RANK_MIN \tab character \cr
   RANK_FGM \tab character \cr
   RANK_FGA \tab character \cr
   RANK_FG_PCT \tab character \cr
   RANK_FG3M \tab character \cr
   RANK_FG3A \tab character \cr
   RANK_FG3_PCT \tab character \cr
   RANK_FTM \tab character \cr
   RANK_FTA \tab character \cr
   RANK_FT_PCT \tab character \cr
   RANK_OREB \tab character \cr
   RANK_DREB \tab character \cr
   RANK_REB \tab character \cr
   RANK_AST \tab character \cr
   RANK_STL \tab character \cr
   RANK_BLK \tab character \cr
   RANK_TOV \tab character \cr
   RANK_PTS \tab character \cr
   RANK_EFF \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Player Career Stats}

\strong{Get NBA Stats API Player Career Stats}
}
\details{
\href{https://www.nba.com/stats/player/2544/career}{Player Career Stats}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_playercareerstats(player_id = '2544')
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Player Functions: 
\code{\link{nba_infographicfanduelplayer}()},
\code{\link{nba_leaguedashplayerbiostats}()},
\code{\link{nba_leaguedashplayerclutch}()},
\code{\link{nba_leaguedashplayershotlocations}()},
\code{\link{nba_leaguedashplayerstats}()},
\code{\link{nba_leagueplayerondetails}()},
\code{\link{nba_leagueseasonmatchups}()},
\code{\link{nba_matchupsrollup}()},
\code{\link{nba_playerawards}()},
\code{\link{nba_playercareerbycollegerollup}()},
\code{\link{nba_playercareerbycollege}()},
\code{\link{nba_playercompare}()},
\code{\link{nba_playerdashboardbyclutch}()},
\code{\link{nba_playerdashboardbygamesplits}()},
\code{\link{nba_playerdashboardbygeneralsplits}()},
\code{\link{nba_playerdashboardbylastngames}()},
\code{\link{nba_playerdashboardbyopponent}()},
\code{\link{nba_playerdashboardbyshootingsplits}()},
\code{\link{nba_playerdashboardbyteamperformance}()},
\code{\link{nba_playerdashboardbyyearoveryear}()},
\code{\link{nba_playerdashptpass}()},
\code{\link{nba_playerdashptreb}()},
\code{\link{nba_playerdashptshotdefend}()},
\code{\link{nba_playerdashptshots}()},
\code{\link{nba_playerestimatedmetrics}()},
\code{\link{nba_playerfantasyprofilebargraph}()},
\code{\link{nba_playerfantasyprofile}()},
\code{\link{nba_playergamelogs}()},
\code{\link{nba_playergamelog}()},
\code{\link{nba_playergamestreakfinder}()},
\code{\link{nba_playerheadshot}()},
\code{\link{nba_playerindex}()},
\code{\link{nba_playernextngames}()},
\code{\link{nba_playerprofilev2}()},
\code{\link{nba_playervsplayer}()}
}
\author{
Saiem Gilani
}
\concept{NBA Player Functions}
