% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_leaders.R
\name{nba_leagueleaders}
\alias{nba_leagueleaders}
\title{\strong{Get NBA Stats API League Leaders}}
\usage{
nba_leagueleaders(
  active_flag = "",
  league_id = "00",
  per_mode = "Totals",
  scope = "S",
  season = year_to_season(most_recent_nba_season() - 1),
  season_type = "Regular Season",
  stat_category = "PTS",
  ...
)
}
\arguments{
\item{active_flag}{Active Flag}

\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{per_mode}{Per Mode - Totals, PerGame, Per48}

\item{scope}{Scope - RS, S, Rookies}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs}

\item{stat_category}{Stat Category: PTS, REB, AST, FG_PCT, FT_PCT, FG3_PCT, STL, BLK}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: LeagueLeaders

\strong{LeagueLeaders}\tabular{ll}{
   col_name \tab types \cr
   PLAYER_ID \tab character \cr
   RANK \tab character \cr
   PLAYER \tab character \cr
   TEAM_ID \tab character \cr
   TEAM \tab character \cr
   GP \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   TOV \tab character \cr
   PF \tab character \cr
   PTS \tab character \cr
   EFF \tab character \cr
   AST_TOV \tab character \cr
   STL_TOV \tab character \cr
}
}
\description{
\strong{Get NBA Stats API League Leaders}

\strong{Get NBA Stats API League Leaders}
}
\details{
\href{https://www.nba.com/stats/leaders}{League Leaders}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_leagueleaders(league_id = '00')
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Leaders Functions: 
\code{\link{nba_alltimeleadersgrids}()},
\code{\link{nba_assistleaders}()},
\code{\link{nba_assisttracker}()},
\code{\link{nba_defensehub}()},
\code{\link{nba_homepageleaders}()},
\code{\link{nba_homepagev2}()},
\code{\link{nba_leaderstiles}()}
}
\author{
Saiem Gilani
}
\concept{NBA Leaders Functions}
