% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hbl_summary.R
\name{hbl_summary}
\alias{hbl_summary}
\title{Model summary}
\usage{
hbl_summary(
  mcmc,
  data,
  response = "response",
  response_type = "raw",
  study = "study",
  study_reference = max(data[[study]]),
  group = "group",
  group_reference = min(data[[group]]),
  patient = "patient",
  rep = "rep",
  rep_reference = min(data[[rep]]),
  covariates = grep("^covariate", colnames(data), value = TRUE),
  constraint = FALSE,
  eoi = 0,
  direction = "<"
)
}
\arguments{
\item{mcmc}{A wide data frame of posterior samples returned by
\code{\link[=hbl_mcmc_hierarchical]{hbl_mcmc_hierarchical()}} or similar MCMC function.}

\item{data}{Tidy data frame with one row per patient per rep,
indicator columns for the response variable,
study, group, patient, rep,
and covariates. All columns must be atomic vectors
(e.g. not lists).}

\item{response}{Character of length 1,
name of the column in \code{data} with the response/outcome variable.
\code{data[[response]]} must be a continuous variable,
and it \emph{should} be the change from baseline of a
clinical endpoint of interest, as opposed to just
the raw response. Treatment differences
are computed directly from this scale, please supply
change from baseline unless you are absolutely certain
that treatment differences computed directly from
this quantity are clinically meaningful.}

\item{response_type}{Character of length 1: \code{"raw"} if the response
column in the data is the raw response, \code{"change"} if the response
columns is change from baseline. In the latter case, the \verb{change_*}
columns in the output table are omitted because the response
is already a change from baseline. Must be one of \code{"raw"} or \code{"change"}.}

\item{study}{Character of length 1,
name of the column in \code{data} with the study ID.}

\item{study_reference}{Atomic of length 1,
element of the \code{study} column that indicates
the current study.
(The other studies are historical studies.)}

\item{group}{Character of length 1,
name of the column in \code{data} with the group ID.}

\item{group_reference}{Atomic of length 1,
element of the \code{group} column that indicates
the control group.
(The other groups may be treatment groups.)}

\item{patient}{Character of length 1,
name of the column in \code{data} with the patient ID.}

\item{rep}{Character of length 1,
name of the column in \code{data} with the rep ID.}

\item{rep_reference}{Atomic of length 1,
element of the \code{rep} column that indicates
baseline, i.e. the first rep chronologically.
(The other reps may be post-baseline study visits or time points.)}

\item{covariates}{Character vector of column names
in \code{data} with the columns with baseline covariates.
These can be continuous, categorical, or binary.
Regardless, \code{historicalborrowlong} derives the appropriate
model matrix.

Each baseline covariate column must truly be a \emph{baseline} covariate:
elements must be equal for all time points within each patient
(after the steps in the "Data processing" section).
In other words, covariates must not be time-varying.

A large number of covariates, or a large number of levels in a
categorical covariate, can severely slow down the computation.
Please consider carefully if you really need to include
such complicated baseline covariates.}

\item{constraint}{Logical of length 1, whether to pool all study arms
at baseline (first rep). Appropriate when the response is the raw
response (as opposed to change from baseline) and the first rep
(i.e. time point) is prior to treatment.}

\item{eoi}{Numeric of length at least 1,
vector of effects of interest (EOIs) for critical success factors (CSFs).}

\item{direction}{Character of length \code{length(eoi)} indicating how
to compare the treatment effect to each EOI. \code{">"} means
Prob(treatment effect > EOI), and \code{"<"} means
Prob(treatment effect < EOI). All elements of \code{direction}
must be either \code{">"} or \code{"<"}.}
}
\value{
A tidy data frame with one row per group (e.g. treatment arm)
and the columns in the following list. Unless otherwise specified,
the quantities are calculated at the group-by-rep level.
Some are calculated for the current (non-historical) study only,
while others pertain to the combined dataset which includes
all historical studies.
\itemize{
\item \code{group}: group index.
\item \code{group_label}: original group label in the data.
\item \code{rep}: rep index.
\item \code{rep_label}: original rep label in the data.
\item \code{data_mean}: observed mean of the response specific to the current
study.
\item \code{data_sd}: observed standard deviation of the response
specific to the current study.
\item \code{data_lower}: lower bound of a simple frequentist 95\% confidence
interval of the observed data mean specific to the current study.
\item \code{data_upper}: upper bound of a simple frequentist 95\% confidence
interval of the observed data mean specific to the current study.
\item \code{data_n}: number of non-missing observations in the combined dataset
(all studies).
\item \code{data_N}: total number of observations (missing and non-missing)
in the combined dataset (all studies).
\item \verb{data_n_study_*}: number of non-missing observations in each study.
The suffixes of these column names are integer study indexes.
Call \code{dplyr::distinct(hbl_data(your_data), study, study_label)}
to see which study labels correspond to these integer indexes.
\item \verb{data_N_study_*}: total number of observations
(missing and non-missing) within each study.
The suffixes of these column names are integer study indexes.
Call \code{dplyr::distinct(hbl_data(your_data), study, study_label)}
to see which study labels correspond to these integer indexes.
\item \code{response_mean}: Estimated posterior mean of the response
from the model. (Here, the response variable in the data
should be a change from baseline outcome.)
Specific to the current study.
\item \code{response_sd}: Estimated posterior standard deviation of the mean
response from the model.
Specific to the current study.
\item \code{response_variance}: Estimated posterior variance of the mean
response from the model.
Specific to the current study.
\item \code{response_lower}: Lower bound of a 95\% posterior interval on the mean
response from the model.
Specific to the current study.
\item \code{response_upper}: Upper bound of a 95\% posterior interval on the mean
response from the model.
Specific to the current study.
\item \code{response_mean_mcse}: Monte Carlo standard error of \code{response_mean}.
\item \code{response_sd_mcse}: Monte Carlo standard error of \code{response_sd}.
\item \code{response_lower_mcse}: Monte Carlo standard error of \code{response_lower}.
\item \code{response_upper_mcse}: Monte Carlo standard error of \code{response_upper}.
\item \verb{change_*}: same as the \verb{response_*} columns, but for change
from baseline instead of the response. Not included if \code{response_type}
is \code{"change"} because in that case the response is already
change from baseline.
\item \verb{change_percent_*}: same as the \verb{change_*} columns, but for the
\emph{percent} change from baseline (from 0\% to 100\%).
Not included if \code{response_type}
is \code{"change"} because in that case the response is already
change from baseline.
Specific to the current study.
\item \verb{diff_*}: same as the \verb{response_*} columns, but for treatment effect.
\item \code{P(diff > EOI)}, \code{P(diff < EOI)}: CSF probabilities on the
treatment effect specified with the \code{eoi} and \code{direction}
arguments.
Specific to the current study.
\item \code{effect_mean}: same as the \verb{response_*} columns, but for the effect size
(diff / residual standard deviation).
Specific to the current study.
\item \verb{precision_ratio*}: same as the \verb{response_*} columns,
but for the precision ratio, which compares within-study variance
to among-study variance. Only returned for the hierarchical model.
Specific to the current study.
}
}
\description{
Summarize a fitted model in a table.
}
\details{
The \code{hb_summary()} function post-processes the results from
the model. It estimates marginal means of the response,
treatment effect, and other quantities of interest.
}
\examples{
if (!identical(Sys.getenv("HBL_TEST", unset = ""), "")) {
set.seed(0)
data <- hbl_sim_pool(
  n_study = 2,
  n_group = 2,
  n_patient = 5,
  n_rep = 3
)$data
tmp <- utils::capture.output(
  suppressWarnings(
    mcmc <- hbl_mcmc_hierarchical(
      data,
      chains = 1,
      warmup = 10,
      iter = 20,
      seed = 0
    )
  )
)
hbl_summary(mcmc, data)
}
}
\seealso{
Other summary: 
\code{\link{hbl_ess}()}
}
\concept{summary}
