% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heterocop.R
\name{CopulaSim}
\alias{CopulaSim}
\title{CopulaSim}
\usage{
CopulaSim(n, R, qdist, random = FALSE)
}
\arguments{
\item{n}{the number of observations}

\item{R}{a correlation matrix of size dxd}

\item{qdist}{a vector containing the names of the marginal quantile functions as well as the number of times they are present in the dataset}

\item{random}{a boolean defining whether the order of the correlation coefficients should be randomized}
}
\value{
a list containing an nxd data frame, the shuffled correlation matrix R, and the permutation leading to the new correlation matrix
}
\description{
This function enables the user to simulate data from a Gaussian copula and arbitrary marginal quantile functions
}
\examples{
M <- diag_block_matrix(c(3,4,5),c(0.7,0.8,0.2))
CopulaSim(20,M,c(rep("qnorm(0,1)",6),rep("qexp(0.5)",4),rep("qbinom(4,0.8)",2)),random=TRUE)

}
