% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hcru_trends.R
\name{plot_hcru}
\alias{plot_hcru}
\title{plot_hcru}
\usage{
plot_hcru(
  summary_df,
  x_var = "time_window",
  y_var = "Cost",
  cohort_col = "cohort",
  facet_var = "care_setting",
  facet_var_n = 3,
  title = "Average total cost by domain and cohort",
  x_label = "Healthcare Setting (Domain)",
  y_label = "Average total cost",
  fill_label = "Cohort"
)
}
\arguments{
\item{summary_df}{Output from estimate_hcru()}

\item{x_var}{A character specifying column name to be plotted on x-axis}

\item{y_var}{A character specifying column name to be plotted on y-axis}

\item{cohort_col}{A character specifying cohort column name}

\item{facet_var}{A character specifying column name to generate faceted plots}

\item{facet_var_n}{A numeric specifying number of columns for facet output}

\item{title}{A character specifying the plot title}

\item{x_label}{A character specifying x-axis label}

\item{y_label}{A character specifying y-axis label}

\item{fill_label}{A character specifying fill legend label}
}
\value{
ggplot object
}
\description{
This function provides the visualization of the events of the settings
grouped by cohort and time window.
}
\details{
Plot HCRU Event Summary
}
\examples{
df <- data.frame(
  time_window = rep(c("Pre", "Post"), each = 2),
  cohort = rep(c("A", "B"), 2),
  care_setting = rep("Setting1", 4),
  Cost = c(100, 120, 110, 130)
)
plot_hcru(
  summary_df = df,
  x_var = "time_window",
  y_var = "Cost",
  cohort_col = "cohort",
  facet_var = "care_setting",
  facet_var_n = 1,
  title = "Example Plot",
  x_label = "Time Window",
  y_label = "Cost",
  fill_label = "Cohort"
)
}
