% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryWO_adhce.R
\name{summaryWO.adhce}
\alias{summaryWO.adhce}
\title{Win odds summary for \code{adhce} objects}
\usage{
\method{summaryWO}{adhce}(x, ...)
}
\arguments{
\item{x}{an \code{adhce} object.}

\item{...}{additional parameters.}
}
\value{
a list containing the summary of wins, losses, and ties. It contains the following named objects:
\itemize{
\item summary a data frame containing number of wins, losses, and ties by treatment group and the overall number of comparisons.
\item summary_by_GROUP (if \code{GROUP} variable is specified) a summary data frame by \code{GROUP}.
\item WO calculated WO (win odds) and WP (win probability) and their standard errors.
}
}
\description{
Win odds summary for \code{adhce} objects
}
\examples{
dat <- as_hce(HCE4)
## `PADY` is not present in the dataset, hence converts it to an `hce` object 
## instead of an `adhce` object.
class(dat)
summaryWO(dat, ref = "P")
## The class is `adhce` hence will use the variable `GROUP`.
HCE4$PADY <- 1080
dat <- as_hce(HCE4) 
class(dat)
summaryWO(dat, ref = "P")
}
\seealso{
\code{\link[=calcWO]{calcWO()}}, \code{\link[=summaryWO]{summaryWO()}}, \code{\link[=summaryWO.data.frame]{summaryWO.data.frame()}}, \code{\link[=summaryWO.formula]{summaryWO.formula()}}, \code{\link[=summaryWO.hce]{summaryWO.hce()}} methods.
}
