% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_check_temp.R
\name{plot_check_temp}
\alias{plot_check_temp}
\title{Visual check of imported temperature data}
\usage{
plot_check_temp(data, dates, temperature, temp_min = 0, temp_max = 25)
}
\arguments{
\item{data}{A data.frame, or data frame extension (e.g. a tibble).}

\item{dates}{Vector of dates for temperature measurements. Must be date or date-time class.}

\item{temperature}{Vector of temperature values.}

\item{temp_min}{Threshold for lower range of expected temperature. Default is 0.}

\item{temp_max}{Threshold for upper range of expected temperature. Default is 25.}
}
\value{
A object of class "gg" and "ggplot" that can be printed to the console
or saved as an image.
}
\description{
The \code{plot_check_temp} function is used to plot imported data to check
temperature values. The function takes a data frame with dates and
temperature values, and plots the temperature values over time. The
function also allows users to specify the visual thresholds for minimum and maximum temperature
values to be plotted.
}
\examples{
library(hatchR)
plot_check_temp(
  data = crooked_river,
  dates = date,
  temperature = temp_c
)
}
