% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdis_sax.R
\name{hdis_sax}
\alias{hdis_sax}
\title{Discord discovery using SAX}
\usage{
hdis_sax(a, w, qtd = 2)
}
\arguments{
\item{a}{alphabet size}

\item{w}{word size}

\item{qtd}{number of occurrences to be classified as discords}
}
\value{
\code{hdis_sax} object
}
\description{
Discord discovery using SAX \url{doi:10.1007/s10618-007-0064-z}
}
\examples{
library(daltoolbox)

# Load motif/discord example data
data(examples_motifs)

# Use a simple sequence example
dataset <- examples_motifs$simple
head(dataset)

# Configure discord discovery via SAX
model <- hdis_sax(26, 3, 3)

# Fit the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected discords
print(detection[(detection$event),])

}
\references{
\itemize{
\item Ogasawara, E., Salles, R., Porto, F., Pacitti, E. Event Detection in Time Series. 1st ed.
Cham: Springer Nature Switzerland, 2025. doi:10.1007/978-3-031-75941-3
}
}
