% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-studies.R
\name{publications_tbl}
\alias{publications_tbl}
\title{Creates a publications table.}
\usage{
publications_tbl(
  study_id = character(),
  pubmed_id = integer(),
  publication_date = lubridate::ymd(),
  publication = character(),
  title = character(),
  author_fullname = character(),
  author_orcid = character()
)
}
\arguments{
\item{study_id}{GWAS Catalog study accession identifier.}

\item{pubmed_id}{\href{https://en.wikipedia.org/wiki/PubMed}{PubMed}
identifier.}

\item{publication_date}{Publication date (online date if available) formatted
as \code{\link[lubridate]{ymd}}.}

\item{publication}{Abbreviated journal name.}

\item{title}{Publication title.}

\item{author_fullname}{Last name and initials of first author.}

\item{author_orcid}{Author's \href{https://en.wikipedia.org/wiki/ORCID}{ORCID
iD} (Open Researcher and Contributor ID).}
}
\value{
A \code{\link[tibble]{tibble}} whose columns are the named arguments
  to the function.
}
\description{
Creates a publications table.
}
\keyword{internal}
