% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_studies.R
\name{get_studies_by_user_requested}
\alias{get_studies_by_user_requested}
\title{Get GWAS Catalog studies that have been requested by users or not}
\usage{
get_studies_by_user_requested(
  user_requested = NULL,
  verbose = FALSE,
  warnings = TRUE,
  page_size = 20L
)
}
\arguments{
\item{user_requested}{A \code{logical} (scalar!) indicating to retrieve
either studies requested by users of the Catalog (\code{TRUE}) or otherwise
(\code{FALSE}).}

\item{verbose}{Whether the function should be verbose about the different
queries or not.}

\item{warnings}{Whether to print warnings.}

\item{page_size}{An integer scalar indicating the
\href{https://www.ebi.ac.uk/gwas/rest/docs/api#_paging_resources}{page}
value to be used in the JSON requests, can be between \code{1} and
\code{1000}.}
}
\value{
A \linkS4class{studies} object.
}
\description{
Gets studies that have either been requested by users of the Catalog
or studies that have not been explicitly requested by users.
}
\keyword{internal}
