% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post-traits.R
\name{child_efo_ids}
\alias{child_efo_ids}
\title{Get all child terms of this trait in the EFO hierarchy}
\usage{
child_efo_ids(
  efo_id,
  verbose = FALSE,
  warnings = TRUE,
  page_size = 20L,
  progress_bar = TRUE
)
}
\arguments{
\item{efo_id}{A \href{https://www.ebi.ac.uk/efo/}{EFO} identifier.}

\item{verbose}{A \code{logical} indicating whether the function should be
verbose about the different queries or not.}

\item{warnings}{A \code{logical} indicating whether to print warnings, if any.}

\item{page_size}{An \code{integer} scalar indicating the
\href{https://www.ebi.ac.uk/gwas/rest/docs/api#_paging_resources}{page}
value to be used in the JSON requests, can be between \code{1} and
\code{1000}.}

\item{progress_bar}{Whether to show a progress bar as the paginated resources
are retrieved.}
}
\value{
A character vector of EFO identifiers.
}
\description{
Get all child terms of this trait in the EFO hierarchy
}
\keyword{internal}
