% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_tibble.R
\name{as_tibble.gtsummary}
\alias{as_tibble.gtsummary}
\alias{as.data.frame.gtsummary}
\title{Convert gtsummary object to a tibble}
\usage{
\method{as_tibble}{gtsummary}(
  x,
  include = everything(),
  col_labels = TRUE,
  return_calls = FALSE,
  fmt_missing = FALSE,
  ...
)

\method{as.data.frame}{gtsummary}(...)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
An object of class \code{"gtsummary"}}

\item{include}{Commands to include in output. Input may be a vector of
quoted or unquoted names. tidyselect and gtsummary select helper
functions are also accepted.
Default is \code{everything()}.}

\item{col_labels}{(scalar \code{logical})\cr
Logical argument adding column labels to output tibble. Default is \code{TRUE}.}

\item{return_calls}{Logical. Default is \code{FALSE}. If \code{TRUE}, the calls are returned
as a list of expressions.}

\item{fmt_missing}{(scalar \code{logical})\cr
Logical argument adding the missing value formats.}

\item{...}{Arguments passed on to \code{gt::gt(...)}}
}
\value{
a \href{https://tibble.tidyverse.org/}{tibble}
}
\description{
Function converts a gtsummary object to a tibble.
}
\examples{
tbl <-
  trial |>
  tbl_summary(by = trt, include = c(age, grade, response))

as_tibble(tbl)

# without column labels
as_tibble(tbl, col_labels = FALSE)
}
\author{
Daniel D. Sjoberg
}
