% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go_home_work.R
\name{go_to_work}
\alias{go_to_work}
\title{go_to_work}
\usage{
go_to_work(wait = 0, start_time)
}
\arguments{
\item{wait}{An integer specifying the n-th next service. That is, \code{wait = n}
will return the n-th available service after the next immediate service.}

\item{start_time}{If given, search for connections after specified time; if
not given, search for connections from current time.}
}
\value{
A \code{data.frame} specifying the next available route from work to home.
}
\description{
Use local environmental variables specifying home and work stations and
locations of locally-stored GTFS data to route from home to work location
with next available service.
}
\details{
This function, and the complementary function \link{go_to_work},
requires three local environmental variables specifying the names of home and
work stations, and the location on local storage of the GTFS data set to be
used for routing. These are respectively called \code{gtfs_home}, \code{gtfs_work}, and
\code{gtfs_data}. This data set must also be pre-processed using the
\link{process_gtfs_local} function.

See \link{Startup} for details on how to set environmental variables.
Briefly, this can be done in two main ways: By setting them at the start of
each session, in which case the variables may be set with:
\code{Sys.setenv ("gtfs_home" = "<my home station>")}
\code{Sys.setenv ("gtfs_work" = "<my work station>")}
\code{Sys.setenv ("gtfs_data" = "/full/path/to/gtfs.zip")}
Alternatively, to set these automatically for each session, paste those lines
into the file \verb{~/.Renviron} - that is, a file named ".Renviron" in the user's
home directory.

The \link{process_gtfs_local} function reduces the GTFS data set to the
minimal possible size necessary for local routing.  GTFS data are
nevertheless typically quite large, and both the \link{go_home} and
\link{go_to_work} functions may take some time to execute. Most of this time
is devoted to loading the data in to the current workspace and as such is
largely unavoidable.
}
\examples{
\dontrun{
# For general use, please set these three variables:
Sys.setenv ("gtfs_home" = "<my home station>")
Sys.setenv ("gtfs_work" = "<my work station>")
Sys.setenv ("gtfs_data" = "/full/path/to/gtfs.zip")

# The following illustrate use with sample data bundled with package
Sys.setenv ("gtfs_home" = "Tempelhof")
Sys.setenv ("gtfs_work" = "Alexanderplatz")
Sys.setenv ("gtfs_data" = file.path (tempdir (), "vbb.zip"))
process_gtfs_local () # If not already done
go_to_work (start_time = "12:00") # next available service after 12:00
go_to_work (3, start_time = "12:00") # Wait until third service after that

# Generally, `start_time` will not be specified, in which case `go_to_work`
# will return next available service from current system time, so calls will
# generally be as simple as:
go_to_work ()
go_to_work (3)
}
}
\seealso{
Other additional: 
\code{\link{go_home}()},
\code{\link{process_gtfs_local}()},
\code{\link{summary.gtfs}()}
}
\concept{additional}
